/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.util.codec;

import be.atbash.util.PublicAPI;
import be.atbash.util.codec.ByteSource;
import be.atbash.util.codec.CodecException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

@PublicAPI
public abstract class CodecSupport {
    public static final String PREFERRED_ENCODING = "UTF-8";

    public static byte[] toBytes(char[] chars) {
        return CodecSupport.toBytes(new String(chars), PREFERRED_ENCODING);
    }

    public static byte[] toBytes(char[] chars, String encoding) throws CodecException {
        return CodecSupport.toBytes(new String(chars), encoding);
    }

    public static byte[] toBytes(String source) {
        return CodecSupport.toBytes(source, PREFERRED_ENCODING);
    }

    public static byte[] toBytes(String source, String encoding) throws CodecException {
        try {
            return source.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            String msg = "Unable to convert source [" + source + "] to byte array using encoding '" + encoding + "'";
            throw new CodecException(msg, e);
        }
    }

    public static String toString(byte[] bytes) {
        return CodecSupport.toString(bytes, PREFERRED_ENCODING);
    }

    public static String toString(byte[] bytes, String encoding) throws CodecException {
        try {
            return new String(bytes, encoding);
        }
        catch (UnsupportedEncodingException e) {
            String msg = "Unable to convert byte array to String with encoding '" + encoding + "'.";
            throw new CodecException(msg, e);
        }
    }

    public static char[] toChars(byte[] bytes) {
        return CodecSupport.toChars(bytes, PREFERRED_ENCODING);
    }

    public static char[] toChars(byte[] bytes, String encoding) throws CodecException {
        return CodecSupport.toString(bytes, encoding).toCharArray();
    }

    protected boolean isByteSource(Object o) {
        return o instanceof byte[] || o instanceof char[] || o instanceof String || o instanceof ByteSource || o instanceof File || o instanceof InputStream;
    }

    public byte[] toBytes(Object o) {
        if (o == null) {
            String msg = "Argument for byte conversion cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        if (o instanceof byte[]) {
            return (byte[])o;
        }
        if (o instanceof ByteSource) {
            return ((ByteSource)o).getBytes();
        }
        if (o instanceof char[]) {
            return CodecSupport.toBytes((char[])o);
        }
        if (o instanceof String) {
            return CodecSupport.toBytes((String)o);
        }
        if (o instanceof File) {
            return this.toBytes((File)o);
        }
        if (o instanceof InputStream) {
            return this.toBytes((InputStream)o);
        }
        return this.objectToBytes(o);
    }

    protected String toString(Object o) {
        if (o == null) {
            String msg = "Argument for String conversion cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        if (o instanceof byte[]) {
            return CodecSupport.toString((byte[])o);
        }
        if (o instanceof char[]) {
            return new String((char[])o);
        }
        if (o instanceof String) {
            return (String)o;
        }
        return this.objectToString(o);
    }

    protected byte[] toBytes(File file) {
        if (file == null) {
            throw new IllegalArgumentException("File argument cannot be null.");
        }
        try {
            return this.toBytes(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            String msg = "Unable to acquire InputStream for file [" + file + "]";
            throw new CodecException(msg, e);
        }
    }

    protected byte[] toBytes(InputStream in) {
        if (in == null) {
            throw new IllegalArgumentException("InputStream argument cannot be null.");
        }
        int BUFFER_SIZE = 512;
        ByteArrayOutputStream out = new ByteArrayOutputStream(512);
        byte[] buffer = new byte[512];
        try {
            int bytesRead;
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException ioe) {
            throw new CodecException(ioe);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected byte[] objectToBytes(Object o) {
        String msg = "The " + this.getClass().getName() + " implementation only supports conversion to byte[] if the source is of type byte[], char[], String, " + ByteSource.class.getName() + " File or InputStream.  The instance provided as a method argument is of type [" + o.getClass().getName() + "].  If you would like to convert this argument type to a byte[], you can 1) convert the argument to one of the supported types yourself and then use that as the method argument or 2) subclass " + this.getClass().getName() + "and override the objectToBytes(Object o) method.";
        throw new CodecException(msg);
    }

    protected String objectToString(Object o) {
        return o.toString();
    }
}

