/*
 * Decompiled with CFR 0.152.
 */
package net.incongru.util.cache;

import net.incongru.util.cache.AbstractCache;
import net.incongru.util.cache.CacheValue;

public class CyclicCache
extends AbstractCache {
    private long timeout;

    public CyclicCache(long timeout) {
        this.timeout = timeout;
    }

    protected CacheValue getNewCacheValue(Object value) {
        return new CyclicCacheValue(value);
    }

    private class CyclicCacheValue
    implements CacheValue {
        private Object value;
        private long creationTime = System.currentTimeMillis();

        public CyclicCacheValue(Object value) {
            this.value = value;
        }

        public boolean isValid() {
            long now = System.currentTimeMillis();
            return now - this.creationTime < CyclicCache.this.timeout;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

