/*
 * Decompiled with CFR 0.152.
 */
package net.incongru.util.cache;

import net.incongru.util.cache.AbstractCache;
import net.incongru.util.cache.CacheValue;

public class TimeoutCache
extends AbstractCache {
    private long timeout;

    public TimeoutCache(long timeout) {
        this.timeout = timeout;
    }

    protected CacheValue getNewCacheValue(Object value) {
        return new TimeoutCacheValue(value);
    }

    private class TimeoutCacheValue
    implements CacheValue {
        private long lastAccess;
        private Object value;

        public TimeoutCacheValue(Object value) {
            this.value = value;
            this.lastAccess = System.currentTimeMillis();
        }

        public boolean isValid() {
            long current = System.currentTimeMillis();
            boolean valid = current - TimeoutCache.this.timeout <= this.lastAccess;
            this.lastAccess = current;
            return valid;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

