/*
 * Decompiled with CFR 0.152.
 */
package ca.pjer.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.layout.EchoLayout;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.WarnStatus;
import com.amazonaws.AmazonClientException;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.services.logs.AWSLogs;
import com.amazonaws.services.logs.AWSLogsClient;
import com.amazonaws.services.logs.model.CreateLogGroupRequest;
import com.amazonaws.services.logs.model.CreateLogStreamRequest;
import com.amazonaws.services.logs.model.DataAlreadyAcceptedException;
import com.amazonaws.services.logs.model.InputLogEvent;
import com.amazonaws.services.logs.model.InvalidSequenceTokenException;
import com.amazonaws.services.logs.model.PutLogEventsRequest;
import com.amazonaws.services.logs.model.PutLogEventsResult;
import com.amazonaws.services.logs.model.ResourceAlreadyExistsException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class AwsLogsAppender
extends AppenderBase<ILoggingEvent> {
    private Layout<ILoggingEvent> layout;
    private String logGroupName;
    private String logStreamName;
    private String logRegion;
    private AWSLogs awsLogs;
    private String sequenceToken;

    public Layout<ILoggingEvent> getLayout() {
        return this.layout;
    }

    public void setLayout(Layout<ILoggingEvent> layout) {
        this.layout = layout;
    }

    public String getLogGroupName() {
        return this.logGroupName;
    }

    public void setLogGroupName(String logGroupName) {
        this.logGroupName = logGroupName;
    }

    public String getLogStreamName() {
        return this.logStreamName;
    }

    public void setLogStreamName(String logStreamName) {
        this.logStreamName = logStreamName;
    }

    public String getLogRegion() {
        return this.logRegion;
    }

    public void setLogRegion(String logRegion) {
        this.logRegion = logRegion;
    }

    public synchronized void start() {
        block11: {
            if (!this.isStarted()) {
                if (this.layout == null) {
                    this.layout = new EchoLayout();
                    this.addStatus((Status)new WarnStatus("No layout, default to " + this.layout, (Object)this));
                }
                if (this.logGroupName == null) {
                    this.logGroupName = ((Object)((Object)this)).getClass().getSimpleName();
                    this.addStatus((Status)new WarnStatus("No logGroupName, default to " + this.logGroupName, (Object)this));
                }
                if (this.logStreamName == null) {
                    this.logStreamName = new SimpleDateFormat("yyyyMMdd'T'HHmmss").format(new Date());
                    this.addStatus((Status)new WarnStatus("No logGroupName, default to " + this.logStreamName, (Object)this));
                }
                try {
                    if (this.awsLogs != null) break block11;
                    AWSLogsClient awsLogs = new AWSLogsClient();
                    if (this.logRegion != null) {
                        awsLogs.setRegion(RegionUtils.getRegion((String)this.logRegion));
                    }
                    try {
                        awsLogs.createLogGroup(new CreateLogGroupRequest().withLogGroupName(this.logGroupName));
                    }
                    catch (ResourceAlreadyExistsException e) {
                        this.addStatus((Status)new InfoStatus(e.getMessage(), (Object)this));
                    }
                    try {
                        awsLogs.createLogStream(new CreateLogStreamRequest().withLogGroupName(this.logGroupName).withLogStreamName(this.logStreamName));
                    }
                    catch (ResourceAlreadyExistsException e) {
                        this.addStatus((Status)new InfoStatus(e.getMessage(), (Object)this));
                    }
                    this.awsLogs = awsLogs;
                    this.layout.start();
                    super.start();
                }
                catch (AmazonClientException e) {
                    this.awsLogs = null;
                    this.addStatus((Status)new ErrorStatus(e.getMessage(), (Object)this, (Throwable)e));
                }
            }
        }
    }

    public synchronized void stop() {
        if (this.isStarted()) {
            if (this.awsLogs != null) {
                this.awsLogs.shutdown();
                this.awsLogs = null;
            }
            super.stop();
            this.layout.stop();
        }
    }

    protected void append(ILoggingEvent event) {
        try {
            PutLogEventsRequest request = new PutLogEventsRequest().withLogGroupName(this.logGroupName).withLogStreamName(this.logStreamName).withSequenceToken(this.sequenceToken).withLogEvents(new InputLogEvent[]{new InputLogEvent().withTimestamp(Long.valueOf(event.getTimeStamp())).withMessage(this.layout.doLayout((Object)event))});
            PutLogEventsResult result = this.awsLogs.putLogEvents(request);
            this.sequenceToken = result.getNextSequenceToken();
        }
        catch (DataAlreadyAcceptedException e) {
            this.sequenceToken = e.getExpectedSequenceToken();
        }
        catch (InvalidSequenceTokenException e) {
            this.sequenceToken = e.getExpectedSequenceToken();
            this.append(event);
        }
    }
}

