/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.npm;

import java.io.File;
import java.io.IOException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.json.model.JsonArray;
import org.hl7.fhir.utilities.json.model.JsonElement;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.json.parser.JsonParser;

public class NpmPackageIndexBuilder {
    public static final Integer CURRENT_INDEX_VERSION = 2;
    private JsonObject index;
    private JsonArray files;

    public void start() {
        this.index = new JsonObject();
        this.index.add("index-version", CURRENT_INDEX_VERSION);
        this.files = new JsonArray();
        this.index.add("files", this.files);
    }

    public boolean seeFile(String name, byte[] content) {
        block11: {
            if (name.endsWith(".json")) {
                try {
                    JsonObject json = JsonParser.parseObject(content);
                    if (json.has("resourceType")) {
                        JsonObject fi = new JsonObject();
                        this.files.add(fi);
                        fi.add("filename", name);
                        fi.add("resourceType", json.asString("resourceType"));
                        if (json.hasPrimitive("id")) {
                            fi.add("id", json.asString("id"));
                        }
                        if (json.hasPrimitive("url")) {
                            fi.add("url", json.asString("url"));
                        }
                        if (json.hasPrimitive("version")) {
                            fi.add("version", json.asString("version"));
                        }
                        if (json.hasPrimitive("kind")) {
                            fi.add("kind", json.asString("kind"));
                        }
                        if (json.hasPrimitive("type")) {
                            fi.add("type", json.asString("type"));
                        }
                        if (json.hasPrimitive("supplements")) {
                            fi.add("supplements", json.asString("supplements"));
                        }
                        if (json.hasPrimitive("content")) {
                            fi.add("content", json.asString("content"));
                        }
                    }
                }
                catch (Exception e) {
                    System.out.println("Error parsing " + name + ": " + e.getMessage());
                    if (!name.contains("openapi")) break block11;
                    return false;
                }
            }
        }
        return true;
    }

    public String build() {
        String res = JsonParser.compose((JsonElement)this.index, true);
        this.index = null;
        this.files = null;
        return res;
    }

    public void executeWithStatus(String folder) throws IOException {
        System.out.print("Index Package " + folder + " ... ");
        this.execute(folder);
        System.out.println("done");
    }

    public void execute(String folder) throws IOException {
        if (this.existsFolder(folder, "package")) {
            folder = Utilities.path(folder, "package");
        }
        if (!this.existsFile(folder, "package.json")) {
            throw new FHIRException("Not a proper package? (can't find package.json)");
        }
        this.start();
        File dir = new File(folder);
        for (File f : dir.listFiles()) {
            this.seeFile(f.getName(), TextFile.fileToBytes(f));
        }
        TextFile.stringToFile(this.build(), Utilities.path(folder, ".index.json"));
    }

    private boolean existsFolder(String ... args) throws IOException {
        File f = new File(Utilities.path(args));
        return f.exists() && f.isDirectory();
    }

    private boolean existsFile(String ... args) throws IOException {
        File f = new File(Utilities.path(args));
        return f.exists() && !f.isDirectory();
    }

    public static void main(String[] args) throws IOException {
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r4.core");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r4.examples");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r4.expansions");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r4.elements");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r3.core");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r3.examples");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r3.expansions");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r3.elements");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r2b.core");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r2b.examples");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r2b.expansions");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r2.core");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r2.examples");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r2.expansions");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r2.elements");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\fhir.test.data\\fhir.test.data.r2");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\fhir.test.data\\fhir.test.data.r3");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\fhir.test.data\\fhir.test.data.r4");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\fhir.tx.support\\fhir.tx.support.r2");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\fhir.tx.support\\fhir.tx.support.r3");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\fhir.tx.support\\fhir.tx.support.r4");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.core#1.0.2");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.core#1.4.0");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.core#3.0.2");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.core#4.0.1");
    }
}

