/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.npm;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.hl7.fhir.utilities.SimpleHTTPClient;
import org.hl7.fhir.utilities.settings.FhirSettings;
import org.hl7.fhir.utilities.settings.PackageServerPOJO;

public class PackageServer {
    private String url;
    private SimpleHTTPClient.AuthenticationMode authenticationMode;
    private PackageServerType serverType;
    private String username;
    private String password;
    private String token;
    public static final String PRIMARY_SERVER = "https://packages.fhir.org";
    public static final String SECONDARY_SERVER = "https://packages2.fhir.org/packages";

    public PackageServer(String url) {
        this.url = url;
        this.authenticationMode = SimpleHTTPClient.AuthenticationMode.NONE;
        this.serverType = PackageServerType.FHIR;
    }

    public String getUrl() {
        return this.url;
    }

    public static PackageServer primaryServer() {
        return new PackageServer(PRIMARY_SERVER);
    }

    public static PackageServer secondaryServer() {
        return new PackageServer(SECONDARY_SERVER);
    }

    public static List<PackageServer> defaultServers() {
        ArrayList<PackageServer> servers = new ArrayList<PackageServer>();
        servers.add(PackageServer.primaryServer());
        servers.add(PackageServer.secondaryServer());
        return servers;
    }

    public static PackageServer getPackageServerFromPOJO(PackageServerPOJO pojo) {
        return new PackageServer(pojo.getUrl()).withAuthenticationMode(PackageServer.getModeFromPOJO(pojo)).withServerType(pojo.getServerType() != null && pojo.getServerType().equalsIgnoreCase("npm") ? PackageServerType.NPM : PackageServerType.FHIR).withUsername(pojo.getUsername()).withPassword(pojo.getPassword()).withToken(pojo.getToken());
    }

    @Nullable
    private static SimpleHTTPClient.AuthenticationMode getModeFromPOJO(PackageServerPOJO pojo) {
        if (pojo.getAuthenticationType().equalsIgnoreCase("basic")) {
            return SimpleHTTPClient.AuthenticationMode.BASIC;
        }
        if (pojo.getAuthenticationType().equalsIgnoreCase("token")) {
            return SimpleHTTPClient.AuthenticationMode.TOKEN;
        }
        return null;
    }

    public static List<PackageServer> getConfiguredServers() {
        return FhirSettings.getPackageServers().stream().map(PackageServer::getPackageServerFromPOJO).collect(Collectors.toList());
    }

    public String toString() {
        return this.url;
    }

    public PackageServer copy() {
        PackageServer packageServer = new PackageServer(this.url);
        packageServer.authenticationMode = this.authenticationMode;
        packageServer.serverType = this.serverType;
        packageServer.username = this.username;
        packageServer.password = this.password;
        packageServer.token = this.token;
        return packageServer;
    }

    public PackageServer withAuthenticationMode(SimpleHTTPClient.AuthenticationMode mode) {
        PackageServer packageServer = this.copy();
        packageServer.authenticationMode = mode;
        return packageServer;
    }

    public PackageServer withServerType(PackageServerType serverType) {
        PackageServer packageServer = this.copy();
        packageServer.serverType = serverType;
        return packageServer;
    }

    public PackageServer withPassword(String password) {
        PackageServer packageServer = this.copy();
        packageServer.password = password;
        return packageServer;
    }

    public PackageServer withUsername(String username) {
        PackageServer packageServer = this.copy();
        packageServer.username = username;
        return packageServer;
    }

    public PackageServer withToken(String token) {
        PackageServer packageServer = this.copy();
        packageServer.token = token;
        return packageServer;
    }

    public SimpleHTTPClient.AuthenticationMode getAuthenticationMode() {
        return this.authenticationMode;
    }

    public PackageServerType getServerType() {
        return this.serverType;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getToken() {
        return this.token;
    }

    public static enum PackageServerType {
        FHIR,
        NPM;

    }
}

