/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.xhtml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlFluent;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class XhtmlNodeList
extends XhtmlFluent
implements List<XhtmlNode>,
Serializable {
    private static final long serialVersionUID = 1L;
    private List<XhtmlNode> list = new ArrayList<XhtmlNode>();
    private boolean inPara;
    private boolean inLink;

    public boolean isInPara() {
        return this.inPara;
    }

    public void setInPara(boolean inPara) {
        this.inPara = inPara;
    }

    public boolean isInLink() {
        return this.inLink;
    }

    public void setInLink(boolean inLink) {
        this.inLink = inLink;
    }

    @Override
    public XhtmlNode addTag(String name) {
        XhtmlNode node = new XhtmlNode(NodeType.Element);
        node.setName(name);
        if (this.isInPara() || name.equals("p")) {
            node.getChildNodes().setInPara(true);
        }
        if (this.isInLink() || name.equals("a")) {
            node.getChildNodes().setInLink(true);
        }
        this.add(node);
        return node;
    }

    @Override
    public XhtmlNode addText(String content) {
        if (content != null) {
            XhtmlNode node = new XhtmlNode(NodeType.Text);
            node.setContent(content);
            this.add(node);
            return node;
        }
        return null;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator<XhtmlNode> iterator() {
        return this.list.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean add(XhtmlNode e) {
        return this.list.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends XhtmlNode> c) {
        return this.list.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends XhtmlNode> c) {
        return this.list.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public XhtmlNode get(int index) {
        return this.list.get(index);
    }

    @Override
    public XhtmlNode set(int index, XhtmlNode element) {
        return this.list.set(index, element);
    }

    @Override
    public void add(int index, XhtmlNode element) {
        this.list.add(index, element);
    }

    @Override
    public XhtmlNode remove(int index) {
        return this.list.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<XhtmlNode> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<XhtmlNode> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public List<XhtmlNode> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    @Override
    protected void addChildren(XhtmlNodeList childNodes) {
        this.addAll(childNodes);
    }
}

