/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v24.group.BAR_P06_PATIENT;
import ca.uhn.hl7v2.model.v24.segment.EVN;
import ca.uhn.hl7v2.model.v24.segment.MSH;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BAR_P06
extends AbstractMessage {
    public BAR_P06() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public BAR_P06(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(EVN.class, true, false);
            this.add(BAR_P06_PATIENT.class, true, true);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating BAR_P06 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.4";
    }

    public MSH getMSH() {
        MSH ret = null;
        try {
            ret = (MSH)this.get("MSH");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public EVN getEVN() {
        EVN ret = null;
        try {
            ret = (EVN)this.get("EVN");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public BAR_P06_PATIENT getPATIENT() {
        BAR_P06_PATIENT ret = null;
        try {
            ret = (BAR_P06_PATIENT)this.get("PATIENT");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public BAR_P06_PATIENT getPATIENT(int rep) {
        BAR_P06_PATIENT ret = null;
        try {
            ret = (BAR_P06_PATIENT)this.get("PATIENT", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPATIENTReps() {
        int reps = -1;
        try {
            reps = this.getAll("PATIENT").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<BAR_P06_PATIENT> getPATIENTAll() throws HL7Exception {
        return this.getAllAsList("PATIENT", BAR_P06_PATIENT.class);
    }

    public void insertPATIENT(BAR_P06_PATIENT structure, int rep) throws HL7Exception {
        super.insertRepetition("PATIENT", (Structure)structure, rep);
    }

    public BAR_P06_PATIENT insertPATIENT(int rep) throws HL7Exception {
        return (BAR_P06_PATIENT)super.insertRepetition("PATIENT", rep);
    }

    public BAR_P06_PATIENT removePATIENT(int rep) throws HL7Exception {
        return (BAR_P06_PATIENT)super.removeRepetition("PATIENT", rep);
    }
}

