package cat.inspiracio.orange;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/** Some classes that help parsing source strings. 
 * 
 * Part has subclasses Literal and Expression. 
 * An expression is like "${o.getName()}" and everything else 
 * is Literal.
 * 
 * For example, 
 * 
 * 	<h2>Name: ${o.getName()}</h2>
 * 
 * is a sequence:
 * 
 * 	Literal("<h2>Name: ")
 * 	Expression("o.getName()")
 * 	Literal("</h2>")
 * */
abstract class Part{
	
	String s;
	
	Part(String s){this.s=s;}
	
	abstract boolean isLiteral();
	
	String getLiteral(){return s;}
	
	String getExpression(){return s;}
	
	@Override public boolean equals(Object o){
		if(o==null)
			return false;
		if(!(o instanceof Part))
			return false;
		Part p=(Part)o;
		return isLiteral()==p.isLiteral() && s.equals(p.s);
	}

	/** Factory: parse a string into literals and expressions. */
    static List<Part>parse(String s) throws IOException{
    	//opt: use StringBuilder
    	
    	List<Part>parts=new ArrayList<Part>();
    	
		int start=s.indexOf("${");
		while(0<=start){
		
			//check that it's not \${...}
			boolean escaped = 1<=start && s.charAt(start-1)=='\\';

			if(escaped){
				//Must output $ for \$

				// s[start-1] = \
				// s[start]   = $
				// s[start+1] = {

				//delete \
				s = s.substring(0, start-1) + s.substring(start);
				
				// look for the next ${
				start=s.indexOf("${", start);
			} 

			else if(!escaped){

				int end=s.indexOf("}", start);
				if(-1==end){
					//String location=getLocation(source);
					String message="Unterminated expression: " + s;// + " at " + location;
					throw new IOException(message);
				}
				//s[end] = '}'
				String prefix=s.substring(0, start);
				if(0<prefix.length())
					parts.add(new Literal(prefix));
				String expression=s.substring(start+2, end);//new String
				parts.add(new Expression(expression));
				s=s.substring(end+1);
				start=s.indexOf("${");
			}
		}
		if(0<s.length())
			parts.add(new Literal(s));
		return parts;
    }
}

class Expression extends Part{
	Expression(String s){super(s);}
	boolean isLiteral(){return false;}
	@Override public String toString(){return "Expression " + s;}
}

class Literal extends Part{
	Literal(String s){super(s);}
	boolean isLiteral(){return true;}
	@Override public String toString(){return "Literal " + s;}
}