/*
 * Decompiled with CFR 0.152.
 */
package cat.inspiracio.orange;

import cat.inspiracio.html.HTMLDocument;
import cat.inspiracio.html.HTMLDocumentBuilder;
import cat.inspiracio.orange.OrangeServlet;
import cat.inspiracio.orange.Programmer;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Mojo(name="orange")
public class OrangeMojo
extends AbstractMojo {
    private static final String WEBAPP = "src/main/webapp";
    private static final String GENERATED_SOURCES = "target/generated-sources";
    @Parameter(defaultValue="${project}")
    private MavenProject project;
    private Log log = this.getLog();
    private OrangeServlet orange = new OrangeServlet();

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.log.info((CharSequence)"Orange mojo");
            this.recurse(new File(WEBAPP));
            this.project.addCompileSourceRoot(GENERATED_SOURCES);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.toString());
        }
    }

    private void recurse(File f) throws Exception {
        if (f.isDirectory()) {
            for (File n : f.listFiles()) {
                this.recurse(n);
            }
            return;
        }
        if (this.isHTML(f)) {
            this.generate(f);
        }
    }

    private void generate(File f) throws Exception {
        String path = f.getPath();
        path = path.substring(WEBAPP.length());
        String packageName = this.orange.packageName(path);
        String className = this.orange.className(path);
        String folder = packageName.replaceAll("\\.", "/");
        String java = "target/generated-sources/" + folder + "/" + className + ".java";
        new File("target/generated-sources/" + folder).mkdirs();
        HTMLDocument d = null;
        try (FileReader r = new FileReader(f);){
            d = this.parse(r);
        }
        var9_9 = null;
        try (FileWriter w = new FileWriter(new File(java));){
            Programmer p = new Programmer(w);
            p.setLog(this.log);
            p.setPackage(packageName);
            p.setClass(className);
            p.document((Document)d);
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
    }

    private HTMLDocument parse(Reader reader) throws IOException, SAXException {
        HTMLDocumentBuilder builder = new HTMLDocumentBuilder();
        InputSource source = new InputSource(reader);
        return builder.parse(source);
    }

    private boolean isHTML(File f) {
        String name = f.getName();
        return name.endsWith(".html");
    }
}

