/*
 * Decompiled with CFR 0.152.
 */
package cat.inspiracio.orange;

import cat.inspiracio.orange.Expression;
import cat.inspiracio.orange.Literal;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

abstract class Part {
    String s;

    Part(String s) {
        this.s = s;
    }

    abstract boolean isLiteral();

    String getLiteral() {
        return this.s;
    }

    String getExpression() {
        return this.s;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Part)) {
            return false;
        }
        Part p = (Part)o;
        return this.isLiteral() == p.isLiteral() && this.s.equals(p.s);
    }

    static List<Part> parse(String s) throws IOException {
        ArrayList<Part> parts = new ArrayList<Part>();
        int start = s.indexOf("${");
        while (0 <= start) {
            boolean escaped;
            boolean bl = escaped = 1 <= start && s.charAt(start - 1) == '\\';
            if (escaped) {
                s = s.substring(0, start - 1) + s.substring(start);
                start = s.indexOf("${", start);
                continue;
            }
            if (escaped) continue;
            int end = s.indexOf("}", start);
            if (-1 == end) {
                String message = "Unterminated expression: " + s;
                throw new IOException(message);
            }
            String prefix = s.substring(0, start);
            if (0 < prefix.length()) {
                parts.add(new Literal(prefix));
            }
            String expression = s.substring(start + 2, end);
            parts.add(new Expression(expression));
            s = s.substring(end + 1);
            start = s.indexOf("${");
        }
        if (0 < s.length()) {
            parts.add(new Literal(s));
        }
        return parts;
    }
}

