/*
 * Decompiled with CFR 0.152.
 */
package cat.inspiracio.orange;

import cat.inspiracio.html.DocumentWriter;
import cat.inspiracio.orange.Part;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.plugin.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class Programmer
extends DocumentWriter {
    private Log log;
    private String packageName;
    private String className;
    private boolean newline = true;
    private int indentation = 0;
    private Set<String> imports;
    private Set<String> declarations = new HashSet<String>();
    private StringBuilder builder = new StringBuilder();

    Programmer(Writer w) {
        super(w);
    }

    void setLog(Log l) {
        this.log = l;
    }

    void setPackage(String p) {
        this.packageName = p;
    }

    void setClass(String c) {
        this.className = c;
    }

    protected Programmer open(Document d) throws Exception {
        this.packageDeclaration();
        this.importStatements(d);
        this.startClass();
        this.constructor();
        this.startWrite();
        return this;
    }

    private void startClass() throws IOException {
        this.write("public class ").write(this.className).writeln(" extends Template{");
        this.writeln();
        this.indent();
    }

    private void constructor() throws IOException {
        this.write("public ").write(this.className).writeln("(){}");
        this.writeln();
    }

    private void packageDeclaration() throws IOException {
        this.write("package ").write(this.packageName).writeln(';');
        this.writeln();
    }

    private void startWrite() throws IOException {
        this.writeln("@Override public final void write() throws Exception {");
        this.indent();
    }

    private void importStatements(Document d) throws IOException {
        this.imports = new TreeSet<String>();
        this.imports.add("cat.inspiracio.orange.Template");
        this.imports(d.getDocumentElement());
        for (String i : this.imports) {
            this.writeln("import " + i + ";");
        }
        this.writeln();
    }

    private void imports(Element e) {
        if (e.hasAttribute("data-import")) {
            String[] is;
            String a = e.getAttribute("data-import");
            for (String i : is = a.split(",")) {
                i = i.trim();
                this.imports.add(i);
            }
            e.removeAttribute("data-import");
        }
        for (Element c : this.childElements(e)) {
            this.imports(c);
        }
    }

    private Collection<Element> childElements(Element e) {
        NodeList children = e.getChildNodes();
        ArrayList<Element> elements = new ArrayList<Element>();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (!(n instanceof Element)) continue;
            elements.add((Element)n);
        }
        return elements;
    }

    protected Programmer doctype(DocumentType type) throws IOException {
        return this.ww("<!DOCTYPE html>");
    }

    protected Programmer element(Element e) throws Exception {
        if (e.hasAttribute("data-if")) {
            return this.dataIf(e);
        }
        if (e.hasAttribute("data-for")) {
            return this.dataFor(e);
        }
        if (e.hasAttribute("data-substitute")) {
            return this.dataSubstitute(e);
        }
        if (e.hasAttribute("data-while")) {
            return this.dataWhile(e);
        }
        super.element(e);
        return this;
    }

    private Programmer dataIf(Element e) throws Exception {
        String v = e.getAttribute("data-if");
        e.removeAttribute("data-if");
        this.log.info((CharSequence)("data-if = " + v));
        return this.writeln("if(" + v + "){").indent().element(e).outdent().writeln('}');
    }

    private Programmer dataFor(Element e) throws Exception {
        String v = e.getAttribute("data-for");
        e.removeAttribute("data-for");
        this.log.info((CharSequence)("data-for = " + v));
        return this.writeln("for(" + v + "){").indent().element(e).outdent().writeln('}');
    }

    private Programmer dataWhile(Element e) throws Exception {
        String v = e.getAttribute("data-while");
        e.removeAttribute("data-while");
        this.log.info((CharSequence)("data-while = " + v));
        return this.writeln("while(" + v + "){").indent().element(e).outdent().writeln('}');
    }

    private Programmer dataSubstitute(Element e) throws IOException {
        String v = e.getAttribute("data-substitute");
        this.log.info((CharSequence)("data-substitute = " + v));
        return this.write("substitute(").literal(v).writeln(");");
    }

    protected Programmer open(Element e) throws Exception {
        boolean b;
        String tag = e.getTagName();
        boolean bl = b = e.hasChildNodes() || this.needClosingTag(tag);
        if (0 == e.getAttributes().getLength()) {
            if (b) {
                this.ww("<" + tag + ">");
            } else {
                this.ww("<" + tag);
            }
        } else {
            this.ww("<" + tag);
            this.attributes(e);
            if (b) {
                this.ww(">");
            }
        }
        return this;
    }

    protected Programmer attribute(String key, String value) throws Exception {
        if (this.empty(value)) {
            return this.ww(" " + key);
        }
        if ("true".equals(value)) {
            return this.ww(" " + key);
        }
        if ("false".equals(value)) {
            return this;
        }
        if (-1 == value.indexOf("${")) {
            return this.ww(" " + key + "=" + this.quote(value));
        }
        if (this.isExpression(value)) {
            String e = value.substring(2, value.length() - 1);
            return this.write("attribute(").literal(key).writeln(", " + e + ");");
        }
        this.ww(" " + key + "=\"");
        List<Part> parts = Part.parse(value);
        for (Part p : parts) {
            if (p.isLiteral()) {
                this.ww(p.getLiteral());
                continue;
            }
            this.write("write(escape(").write(p.getExpression()).writeln("));");
        }
        return this.ww("\"");
    }

    private boolean isExpression(String value) {
        return value != null && 3 < value.length() && value.startsWith("${") && value.endsWith("}") && -1 == value.indexOf("${", 2);
    }

    protected Programmer text(String s) throws Exception {
        if (this.whitespace(s)) {
            return this.ww(" ");
        }
        List<Part> parts = Part.parse(s);
        for (Part p : parts) {
            if (p.isLiteral()) {
                this.ww(this.escape(p.getLiteral()));
                continue;
            }
            this.writeln("write(" + p.getExpression() + ");");
        }
        return this;
    }

    private boolean whitespace(String s) {
        return s.trim().isEmpty();
    }

    private String escape(String s) {
        if (s == null) {
            return null;
        }
        return s.replace("&", "&amp;").replace("<", "&lt;");
    }

    protected Programmer close(Element e) throws IOException {
        boolean b;
        String tag = e.getTagName();
        boolean bl = b = e.hasChildNodes() || this.needClosingTag(tag);
        if (b) {
            return this.ww("</" + tag + ">");
        }
        return this.ww("/>");
    }

    protected Void close(Document d) throws Exception {
        this.endWrite();
        this.declarations();
        this.endClass();
        return null;
    }

    private Programmer declarations() throws IOException {
        if (this.declarations != null) {
            for (String d : this.declarations) {
                this.writeln(d);
            }
        }
        return this;
    }

    private Programmer endWrite() throws IOException {
        return this.outdent().writeln().writeln('}').writeln();
    }

    private Programmer endClass() throws IOException {
        return this.outdent().writeln('}').writeln();
    }

    protected void script(Element element) throws Exception {
        if (this.isDeclaration(element)) {
            String source = element.getTextContent();
            this.declarations.add(source);
            return;
        }
        if (this.isServerScript(element)) {
            String source = element.getTextContent();
            if (!this.empty(source)) {
                this.writeln(source);
            }
            return;
        }
        this.open(element);
        String s = element.getTextContent();
        if (!this.empty(s)) {
            this.ww(s);
        }
        this.close(element);
    }

    private boolean isServerScript(Element e) {
        String type = e.getAttribute("type");
        return "server/java".equals(type);
    }

    private boolean isDeclaration(Element e) {
        return e.hasAttribute("data-declare");
    }

    protected Programmer cdata(String s) throws Exception {
        return this;
    }

    protected Programmer comment(String s) throws Exception {
        return this;
    }

    protected String quote(String value) {
        if (this.contains(value, '\"')) {
            value = value.replaceAll("\"", "&quot;");
        }
        return '\"' + value + '\"';
    }

    private boolean okUnquoted(String s) {
        if (s.isEmpty()) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) {
                return false;
            }
            switch (c) {
                case '\"': 
                case '\'': 
                case '<': 
                case '=': 
                case '>': 
                case '`': {
                    return false;
                }
            }
        }
        return true;
    }

    private boolean contains(String value, char c) {
        return 0 <= value.indexOf(c);
    }

    private Programmer indent() throws IOException {
        this.flush();
        ++this.indentation;
        return this;
    }

    private Programmer outdent() throws IOException {
        this.flush();
        --this.indentation;
        return this;
    }

    private void dent() throws IOException {
        if (this.newline) {
            for (int i = 0; i < this.indentation; ++i) {
                super.write('\t');
            }
        }
        this.newline = false;
    }

    public Programmer write(char c) throws IOException {
        this.flush();
        this.dent();
        super.write(c);
        return this;
    }

    public Programmer write(String s) throws IOException {
        if (this.empty(s)) {
            return this;
        }
        this.flush();
        this.dent();
        super.write(s);
        return this;
    }

    protected Programmer writeln() throws IOException {
        this.flush();
        super.writeln();
        this.newline = true;
        return this;
    }

    public Programmer writeln(char c) throws IOException {
        this.flush();
        this.dent();
        super.writeln(c);
        return this;
    }

    public Programmer writeln(String s) throws IOException {
        this.flush();
        this.dent();
        super.writeln(s);
        return this;
    }

    private Programmer accumulate(String s) {
        this.builder.append(s);
        return this;
    }

    private Programmer flush() throws IOException {
        if (this.builder.length() == 0) {
            return this;
        }
        String s = this.builder.toString();
        this.builder.setLength(0);
        return this.write("write(").literal(s).writeln(");");
    }

    private Programmer ww(String s) throws IOException {
        if (this.empty(s)) {
            return this;
        }
        return this.accumulate(s);
    }

    private Programmer literal(String s) throws IOException {
        this.write('\"');
        block6: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    this.write("\\\\");
                    continue block6;
                }
                case '\"': {
                    this.write("\\\"");
                    continue block6;
                }
                case '\n': {
                    this.write("\\n");
                    continue block6;
                }
                case '\r': {
                    this.write("\\r");
                    continue block6;
                }
                default: {
                    this.write(c);
                }
            }
        }
        return this.write('\"');
    }

    private boolean empty(String value) {
        return value == null || 0 == value.length();
    }
}

