/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.io.watch;

import cn.hutool.core.io.watch.WatchMonitor;
import cn.hutool.core.io.watch.Watcher;
import cn.hutool.core.util.URLUtil;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.WatchEvent;

public class WatchUtil {
    public static WatchMonitor create(URL url, WatchEvent.Kind<?> ... events) {
        return WatchUtil.create(url, 0, events);
    }

    public static WatchMonitor create(URL url, int maxDepth, WatchEvent.Kind<?> ... events) {
        return WatchUtil.create(URLUtil.toURI(url), maxDepth, events);
    }

    public static WatchMonitor create(URI uri, WatchEvent.Kind<?> ... events) {
        return WatchUtil.create(uri, 0, events);
    }

    public static WatchMonitor create(URI uri, int maxDepth, WatchEvent.Kind<?> ... events) {
        return WatchUtil.create(Paths.get(uri), maxDepth, events);
    }

    public static WatchMonitor create(File file, WatchEvent.Kind<?> ... events) {
        return WatchUtil.create(file, 0, events);
    }

    public static WatchMonitor create(File file, int maxDepth, WatchEvent.Kind<?> ... events) {
        return WatchUtil.create(file.toPath(), maxDepth, events);
    }

    public static WatchMonitor create(String path, WatchEvent.Kind<?> ... events) {
        return WatchUtil.create(path, 0, events);
    }

    public static WatchMonitor create(String path, int maxDepth, WatchEvent.Kind<?> ... events) {
        return WatchUtil.create(Paths.get(path, new String[0]), maxDepth, events);
    }

    public static WatchMonitor create(Path path, WatchEvent.Kind<?> ... events) {
        return WatchUtil.create(path, 0, events);
    }

    public static WatchMonitor create(Path path, int maxDepth, WatchEvent.Kind<?> ... events) {
        return new WatchMonitor(path, maxDepth, events);
    }

    public static WatchMonitor createAll(URL url, Watcher watcher) {
        return WatchUtil.createAll(url, 0, watcher);
    }

    public static WatchMonitor createAll(URL url, int maxDepth, Watcher watcher) {
        return WatchUtil.createAll(URLUtil.toURI(url), maxDepth, watcher);
    }

    public static WatchMonitor createAll(URI uri, Watcher watcher) {
        return WatchUtil.createAll(uri, 0, watcher);
    }

    public static WatchMonitor createAll(URI uri, int maxDepth, Watcher watcher) {
        return WatchUtil.createAll(Paths.get(uri), maxDepth, watcher);
    }

    public static WatchMonitor createAll(File file, Watcher watcher) {
        return WatchUtil.createAll(file, 0, watcher);
    }

    public static WatchMonitor createAll(File file, int maxDepth, Watcher watcher) {
        return WatchUtil.createAll(file.toPath(), 0, watcher);
    }

    public static WatchMonitor createAll(String path, Watcher watcher) {
        return WatchUtil.createAll(path, 0, watcher);
    }

    public static WatchMonitor createAll(String path, int maxDepth, Watcher watcher) {
        return WatchUtil.createAll(Paths.get(path, new String[0]), maxDepth, watcher);
    }

    public static WatchMonitor createAll(Path path, Watcher watcher) {
        return WatchUtil.createAll(path, 0, watcher);
    }

    public static WatchMonitor createAll(Path path, int maxDepth, Watcher watcher) {
        WatchMonitor watchMonitor = WatchUtil.create(path, maxDepth, WatchMonitor.EVENTS_ALL);
        watchMonitor.setWatcher(watcher);
        return watchMonitor;
    }
}

