/*
 * Decompiled with CFR 0.152.
 */
package coconut.aio;

import coconut.aio.AioFuture;
import coconut.aio.AsyncDatagramGroup;
import coconut.aio.AsyncDatagramSource;
import coconut.aio.ReadHandler;
import coconut.aio.monitor.DatagramMonitor;
import coconut.aio.spi.AioProvider;
import coconut.core.Colored;
import coconut.core.Handler;
import coconut.core.Offerable;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.Executor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AsyncDatagram
implements Colored {
    public abstract long getId();

    public abstract int getColor();

    public abstract DatagramSocket socket();

    public abstract InetAddress getInetAddress();

    public abstract SocketAddress getLocalSocketAddress();

    public abstract int getPort();

    public abstract InetAddress getLocalAddress();

    public abstract SocketAddress getRemoteSocketAddress();

    public abstract int getLocalPort();

    public abstract AsyncDatagram bind(SocketAddress var1) throws IOException;

    public abstract boolean isBound();

    public abstract boolean isConnected();

    public abstract AsyncDatagram setBufferLimit(long var1);

    public abstract long getBufferLimit();

    public abstract AsyncDatagram setWriteQueueLimit(int var1);

    public abstract int getWriteQueueLimit();

    public static AsyncDatagram open() throws IOException {
        return AioProvider.provider().openDatagram();
    }

    public static AsyncDatagram open(Offerable<? super Event> queue) throws IOException {
        return AioProvider.provider().openDatagram(queue);
    }

    public static AsyncDatagram open(Queue<? super Event> queue) throws IOException {
        return AioProvider.provider().openDatagram(queue);
    }

    public static AsyncDatagram open(Executor executor) throws IOException {
        return AioProvider.provider().openDatagram(executor);
    }

    public abstract AsyncDatagram connect(SocketAddress var1) throws IOException;

    public abstract AsyncDatagram disconnect() throws IOException;

    public abstract Written write(ByteBuffer var1);

    public Written write(ByteBuffer[] srcs) {
        return this.write(srcs, 0, srcs.length);
    }

    public abstract Written write(ByteBuffer[] var1, int var2, int var3);

    public abstract ReaderSet setReader(ReadHandler<AsyncDatagram> var1);

    public abstract ReadHandler<AsyncDatagram> getReader();

    public abstract Closed close();

    public abstract AsyncDatagram setGroup(AsyncDatagramGroup var1);

    public abstract AsyncDatagramGroup getGroup();

    public static void setDefaultMonitor(DatagramMonitor monitor) {
        AioProvider.provider().setDefaultMonitor(monitor);
    }

    public static DatagramMonitor getDefaultMonitor() {
        return AioProvider.provider().getDefaultDatagramMonitor();
    }

    public abstract AsyncDatagram setMonitor(DatagramMonitor var1);

    public abstract DatagramMonitor getMonitor();

    public abstract Object attach(Object var1);

    public abstract Object attachment();

    public abstract Offerable<? super Event> getDefaultDestination();

    public abstract Executor getDefaultExecutor();

    public abstract AsyncDatagram setCloseHandler(Handler<AsyncDatagram> var1);

    public abstract Handler<AsyncDatagram> getCloseHandler();

    public abstract boolean isOpen();

    public abstract AsyncDatagramSource getSource();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Written
    extends Event,
    AioFuture<Long, Event> {
        public int getLength();

        public int getOffset();

        public SocketAddress getAddress();

        public long getBytesWritten();

        public ByteBuffer[] getSrcs();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ReaderSet
    extends Event,
    AioFuture {
        public ReadHandler<AsyncDatagram> getReader();
    }

    public static interface Closed
    extends Event,
    AioFuture {
        public Throwable getCause();
    }

    public static interface ErroneousEvent
    extends Event {
        public Throwable getCause();

        public String getMessage();

        public Event getEvent();
    }

    public static interface Event
    extends Colored {
        public AsyncDatagram async();
    }
}

