/*
 * Decompiled with CFR 0.152.
 */
package coconut.aio;

import coconut.aio.AioFuture;
import coconut.aio.monitor.FileMonitor;
import coconut.aio.spi.AioProvider;
import coconut.core.Colored;
import coconut.core.Offerable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Queue;
import java.util.concurrent.Executor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AsyncFile
implements Colored {
    public static AsyncFile open() throws IOException {
        return AioProvider.provider().openFile();
    }

    public static AsyncFile open(Offerable<? super Event> queue) throws IOException {
        return AioProvider.provider().openFile(queue);
    }

    public static AsyncFile open(Executor executor) throws IOException {
        return AioProvider.provider().openFile(executor);
    }

    public static AsyncFile open(Queue<? super Event> queue) throws IOException {
        return AioProvider.provider().openFile(queue);
    }

    public static void setDefaultMonitor(FileMonitor monitor) {
        AioProvider.provider().setDefaultMonitor(monitor);
    }

    public static FileMonitor getDefaultMonitor() {
        return AioProvider.provider().getDefaultFileMonitor();
    }

    public abstract int getColor();

    public abstract boolean isOpen();

    public abstract Opened openFile(File var1, String var2);

    public abstract Opened openFile(String var1, String var2);

    public abstract TransferedTo transferTo(long var1, long var3, WritableByteChannel var5);

    public abstract Truncated truncate(long var1);

    public abstract boolean isWritable();

    public abstract AsyncFile setMonitor(FileMonitor var1);

    public abstract FileMonitor getMonitor();

    public abstract Offerable<? super Event> getDefaultDestination();

    public abstract Executor getDefaultExecutor();

    public abstract Object attach(Object var1);

    public abstract Object attachment();

    public abstract long getId();

    public abstract File getFile();

    public abstract Closed close();

    public static interface TransferedTo
    extends Event,
    AioFuture {
        public long getBytesTransfered();

        public long getCount();

        public long getPosition();

        public WritableByteChannel getTarget();
    }

    public static interface TransferedFrom
    extends Event,
    AioFuture {
        public long getBytesTransfered();

        public long getCount();

        public long getPosition();

        public ReadableByteChannel getSrc();
    }

    public static interface Closed
    extends Event,
    AioFuture {
        public Throwable getCause();
    }

    public static interface Lock
    extends Event {
        public FileLock getLock();

        public long getPosition();

        public boolean isShared();

        public long getSize();
    }

    public static interface Forced
    extends Event {
        public boolean getMetadata();
    }

    public static interface Map
    extends Event {
        public MappedByteBuffer getBuffer();

        public FileChannel.MapMode getMode();

        public long getPosition();

        public long getSize();
    }

    public static interface Position
    extends Event {
        public long getPosition();
    }

    public static interface Size
    extends Event {
        public long getSize();
    }

    public static interface NewPosition
    extends Event {
        public long getNewPosition();
    }

    public static interface Opened
    extends Event,
    AioFuture {
        public File getFile();

        public String getMode();
    }

    public static interface Truncated
    extends Event {
        public long getSize();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Written
    extends Event,
    AioFuture<Long, Event> {
        public int getLength();

        public int getOffset();

        public long getPosition();

        public long getBytesWritten();

        public ByteBuffer[] getSrcs();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Read
    extends Event,
    AioFuture<Long, Event> {
        public int getLength();

        public int getOffset();

        public long getBytesRead();

        public long getPosition();

        public ByteBuffer[] getDsts();
    }

    public static interface ErroneousEvent
    extends Event {
        public Throwable getCause();

        public String getMessage();

        public Event getEvent();
    }

    public static interface Event
    extends Colored {
        public AsyncFile async();
    }
}

