/*
 * Decompiled with CFR 0.152.
 */
package coconut.aio;

import coconut.aio.AcceptPolicy;
import coconut.aio.AioFuture;
import coconut.aio.AsyncSocket;
import coconut.aio.AsyncSocketGroup;
import coconut.aio.monitor.ServerSocketMonitor;
import coconut.aio.spi.AioProvider;
import coconut.core.Callback;
import coconut.core.Colored;
import coconut.core.Handler;
import coconut.core.Offerable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.util.Queue;
import java.util.concurrent.Executor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AsyncServerSocket
implements Colored {
    public abstract long getId();

    public abstract int getColor();

    public abstract ServerSocket socket();

    public abstract boolean isAccepting();

    public abstract AsyncSocket accept() throws IOException;

    public abstract AcceptingStarted startAccepting(Executor var1, Callback<AsyncSocket> var2);

    public abstract AcceptingStarted startAccepting(Executor var1, Callback<AsyncSocket> var2, AcceptPolicy var3);

    public abstract AcceptingStarted startAccepting(Offerable<? super Event> var1);

    public abstract AcceptingStarted startAccepting(Offerable<? super Event> var1, AcceptPolicy var2);

    public abstract AcceptingStopped stopAccepting();

    public abstract Closed close();

    public static void setDefaultMonitor(ServerSocketMonitor monitor) {
        AioProvider.provider().setDefaultMonitor(monitor);
    }

    public static ServerSocketMonitor getDefaultMonitor() {
        return AioProvider.provider().getDefaultServerSocketMonitor();
    }

    public abstract AsyncServerSocket setMonitor(ServerSocketMonitor var1);

    public abstract ServerSocketMonitor getMonitor();

    public abstract Object attach(Object var1);

    public abstract Object attachment();

    public abstract Offerable<? super Event> getDefaultDestination();

    public abstract Executor getDefaultExecutor();

    public abstract AsyncServerSocket setDefaultSocketGroup(AsyncSocketGroup var1);

    public abstract AsyncSocketGroup getDefaultSocketGroup();

    public abstract boolean isOpen();

    public abstract AsyncServerSocket setCloseHandler(Handler<AsyncServerSocket> var1);

    public abstract Handler<AsyncServerSocket> getCloseHandler();

    public abstract AsyncServerSocket bind(SocketAddress var1) throws IOException;

    public abstract AsyncServerSocket bind(SocketAddress var1, int var2) throws IOException;

    public static AsyncServerSocket open() throws IOException {
        return AioProvider.provider().openServerSocket();
    }

    public static AsyncServerSocket open(Offerable<? super Event> destination) throws IOException {
        return AioProvider.provider().openServerSocket(destination);
    }

    public static AsyncServerSocket open(Executor executor) throws IOException {
        return AioProvider.provider().openServerSocket(executor);
    }

    public static AsyncServerSocket open(Queue<? super Event> queue) throws IOException {
        return AioProvider.provider().openServerSocket(queue);
    }

    public abstract boolean isBound();

    public abstract InetAddress getInetAddress();

    public abstract SocketAddress getLocalSocketAddress();

    public abstract int getLocalPort();

    public static interface AcceptingStarted
    extends Event,
    AioFuture {
        public AcceptPolicy getPolicy();
    }

    public static interface AcceptingStopped
    extends Event,
    AioFuture {
    }

    public static interface Closed
    extends Event,
    AioFuture {
        public Throwable getCause();
    }

    public static interface SocketAccepted
    extends Event,
    AioFuture {
        public AsyncSocket getAcceptedSocket();
    }

    public static interface ErroneousEvent
    extends Event {
        public Throwable getCause();

        public String getMessage();

        public Event getEvent();
    }

    public static interface Event
    extends Colored {
        public AsyncServerSocket async();
    }
}

