/*
 * Decompiled with CFR 0.152.
 */
package coconut.aio;

import coconut.aio.AioFuture;
import coconut.aio.AsyncSocketGroup;
import coconut.aio.ReadHandler;
import coconut.aio.monitor.SocketMonitor;
import coconut.aio.spi.AioProvider;
import coconut.core.Colored;
import coconut.core.Handler;
import coconut.core.Offerable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.util.Queue;
import java.util.concurrent.Executor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AsyncSocket
implements Colored {
    public abstract long getId();

    public abstract int getColor();

    public abstract Socket socket();

    public abstract ByteChannel channel();

    public abstract InetAddress getInetAddress();

    public abstract SocketAddress getLocalSocketAddress();

    public abstract int getPort();

    public abstract InetAddress getLocalAddress();

    public abstract SocketAddress getRemoteSocketAddress();

    public abstract int getLocalPort();

    public abstract AsyncSocket bind(SocketAddress var1) throws IOException;

    public abstract boolean isBound();

    public abstract boolean isConnected();

    public abstract AsyncSocket setBufferLimit(long var1);

    public abstract long getBufferLimit();

    public abstract AsyncSocket setWriteQueueLimit(int var1);

    public abstract int getWriteQueueLimit();

    public static AsyncSocket open() throws IOException {
        return AioProvider.provider().openSocket();
    }

    public static AsyncSocket open(Offerable<? super Event> destination) throws IOException {
        return AioProvider.provider().openSocket(destination);
    }

    public static AsyncSocket open(Queue<? super Event> queue) throws IOException {
        return AioProvider.provider().openSocket(queue);
    }

    public static AsyncSocket open(Executor executor) throws IOException {
        return AioProvider.provider().openSocket(executor);
    }

    public abstract Connected connect(SocketAddress var1);

    public abstract Written write(ByteBuffer var1);

    public Written write(ByteBuffer[] srcs) {
        return this.write(srcs, 0, srcs.length);
    }

    public abstract Written write(ByteBuffer[] var1, int var2, int var3);

    public abstract ReaderSet setReader(ReadHandler<AsyncSocket> var1);

    public abstract ReadHandler<AsyncSocket> getReader();

    public abstract Closed close();

    public abstract AsyncSocket setGroup(AsyncSocketGroup var1);

    public abstract AsyncSocketGroup getGroup();

    public static void setDefaultMonitor(SocketMonitor monitor) {
        AioProvider.provider().setDefaultMonitor(monitor);
    }

    public static SocketMonitor getDefaultMonitor() {
        return AioProvider.provider().getDefaultSocketMonitor();
    }

    public abstract AsyncSocket setMonitor(SocketMonitor var1);

    public abstract SocketMonitor getMonitor();

    public abstract Object attach(Object var1);

    public abstract Object attachment();

    public abstract Offerable<? super Event> getDefaultDestination();

    public abstract Executor getDefaultExecutor();

    public abstract AsyncSocket setCloseHandler(Handler<AsyncSocket> var1);

    public abstract Handler<AsyncSocket> getCloseHandler();

    public abstract boolean isOpen();

    public abstract ScatteringByteChannel getSource();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Written
    extends Event,
    AioFuture<Long, Event> {
        public int getLength();

        public int getOffset();

        public long getBytesWritten();

        public ByteBuffer[] getSrcs();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ReaderSet
    extends Event,
    AioFuture {
        public ReadHandler<AsyncSocket> getReader();
    }

    public static interface Read
    extends Event {
        public int getLength();

        public int getOffset();

        public long getBytesWritten();

        public ByteBuffer[] getSrcs();
    }

    public static interface Connected
    extends Event,
    AioFuture {
        public SocketAddress getSocketAddress();
    }

    public static interface Closed
    extends Event,
    AioFuture {
        public Throwable getCause();
    }

    public static interface ErroneousEvent
    extends Event {
        public Throwable getCause();

        public String getMessage();

        public Event getEvent();
    }

    public static interface Event
    extends Colored {
        public AsyncSocket async();
    }
}

