/*
 * Decompiled with CFR 0.152.
 */
package coconut.aio.management;

import java.io.Serializable;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketAddress;

public class DatagramInfo
implements Serializable {
    private final long id;
    private final long creationDate;
    private final long deadDate;
    private final boolean isConnected;
    private final boolean isBound;
    private final long datagramGroupId;
    private final InetAddress inetAddress;
    private final SocketAddress localSocketAddress;
    private final int port;
    private final int localPort;
    private final SocketAddress remoteSocketAddress;
    private final InetAddress localAddress;
    private final long bytesWritten;
    private final long bytesRead;

    public DatagramInfo(long id, long groupId, long creationDate, long deadDate, DatagramSocket socket, long bytesRead, long bytesWritten) {
        this.id = id;
        this.creationDate = creationDate;
        this.deadDate = deadDate;
        this.bytesWritten = bytesWritten;
        this.bytesRead = bytesRead;
        this.datagramGroupId = groupId;
        this.isBound = socket.isBound();
        this.isConnected = socket.isConnected();
        this.inetAddress = socket.getInetAddress();
        this.localSocketAddress = socket.getLocalSocketAddress();
        this.port = socket.getPort();
        this.localPort = socket.getLocalPort();
        this.remoteSocketAddress = socket.getRemoteSocketAddress();
        this.localAddress = socket.getLocalAddress();
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public long getDeadDate() {
        return this.deadDate;
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    public SocketAddress getLocalSocketAddress() {
        return this.localSocketAddress;
    }

    public int getPort() {
        return this.port;
    }

    public InetAddress getLocalAddress() {
        return this.localAddress;
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.remoteSocketAddress;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public boolean isBound() {
        return this.isBound;
    }

    public long getGroupId() {
        return this.datagramGroupId;
    }

    public long getId() {
        return this.id;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AsyncDatagram[id=");
        builder.append(this.id);
        if (this.isConnected) {
            builder.append(",addr=");
            builder.append(this.inetAddress);
            builder.append(":");
            builder.append(this.port);
            builder.append(",local=");
            builder.append(this.localAddress);
            builder.append(":");
            builder.append(this.localPort);
        } else {
            builder.append(",unconnected");
        }
        builder.append(",");
        builder.append(this.bytesRead);
        builder.append(" bytes read,");
        builder.append(this.bytesWritten);
        builder.append(" bytes written]");
        return builder.toString();
    }
}

