/*
 * Decompiled with CFR 0.152.
 */
package coconut.aio.spi;

import coconut.aio.management.DatagramMBean;
import coconut.aio.management.FileMBean;
import coconut.aio.management.ServerSocketMBean;
import coconut.aio.management.SocketMBean;
import coconut.aio.monitor.DatagramGroupMonitor;
import coconut.aio.monitor.DatagramMonitor;
import coconut.aio.monitor.FileMonitor;
import coconut.aio.monitor.ServerSocketMonitor;
import coconut.aio.monitor.SocketGroupMonitor;
import coconut.aio.monitor.SocketMonitor;
import coconut.aio.spi.AsyncFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;

public abstract class AioProvider
implements AsyncFactory {
    private static final Object lock = new Object();
    private static AioProvider provider;
    protected static final Properties properties;

    protected AioProvider() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("aioProvider"));
        }
    }

    protected static Object instantiateObject(String className) {
        if (className == null) {
            throw new NullPointerException("className");
        }
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> c = Class.forName(className, true, loader);
            return c.newInstance();
        }
        catch (ClassNotFoundException x) {
            throw new RuntimeException(x);
        }
        catch (IllegalAccessException x) {
            throw new RuntimeException(x);
        }
        catch (InstantiationException x) {
            throw new RuntimeException(x);
        }
        catch (SecurityException x) {
            throw new RuntimeException(x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AioProvider provider() {
        Object object = lock;
        synchronized (object) {
            if (provider != null) {
                return provider;
            }
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("coconut/aio/coconut-aio.conf");
            try {
                properties.load(is);
            }
            catch (IOException ioe) {
                throw new IllegalStateException("The internal default coconut-aio.conf is missing. This is highly irregular, your Coconut JAR is most likely corrupt.");
            }
            Enumeration<?> en = System.getProperties().propertyNames();
            while (en.hasMoreElements()) {
                String s = (String)en.nextElement();
                if (!s.startsWith("coconut.aio")) continue;
                properties.put(s, System.getProperties().getProperty(s));
            }
            String cn = properties.getProperty("coconut.aio.spi.AioProvider");
            provider = (AioProvider)AioProvider.instantiateObject(cn);
            return provider;
        }
    }

    public abstract void setDefaultMonitor(ServerSocketMonitor var1);

    public abstract ServerSocketMonitor getDefaultServerSocketMonitor();

    public abstract void setDefaultMonitor(SocketMonitor var1);

    public abstract SocketMonitor getDefaultSocketMonitor();

    public abstract void setDefaultMonitor(SocketGroupMonitor var1);

    public abstract SocketGroupMonitor getDefaultSocketGroupMonitor();

    public abstract void setDefaultMonitor(DatagramMonitor var1);

    public abstract DatagramMonitor getDefaultDatagramMonitor();

    public abstract void setDefaultMonitor(DatagramGroupMonitor var1);

    public abstract DatagramGroupMonitor getDefaultDatagramGroupMonitor();

    public abstract void setDefaultMonitor(FileMonitor var1);

    public abstract FileMonitor getDefaultFileMonitor();

    public abstract ServerSocketMBean getServerSocketMXBeanServer();

    public abstract SocketMBean getSocketMXBeanServer();

    public abstract DatagramMBean getDatagramMXBeanServer();

    public abstract FileMBean getFileMXBeanServer();

    static {
        properties = new Properties();
    }
}

