/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dcm;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class DnsCacheEntry
implements Serializable {
    private static final long serialVersionUID = -7476648934387757732L;
    private final String host;
    private final String[] ips;
    private final Date expiration;

    public String getHost() {
        return this.host;
    }

    public String[] getIps() {
        String[] copy = new String[this.ips.length];
        System.arraycopy(this.ips, 0, copy, 0, this.ips.length);
        return copy;
    }

    public String getIp() {
        return this.ips[0];
    }

    public Date getExpiration() {
        return this.expiration;
    }

    public DnsCacheEntry(String host, String[] ips, Date expiration) {
        this.host = host;
        this.ips = ips;
        this.expiration = expiration;
    }

    public String toString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        return "DnsCacheEntry{host='" + this.host + '\'' + ", ips=" + Arrays.toString(this.ips) + ", expiration=" + dateFormat.format(this.expiration) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DnsCacheEntry that = (DnsCacheEntry)o;
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        if (!Arrays.equals(this.ips, that.ips)) {
            return false;
        }
        return !(this.expiration == null ? that.expiration != null : !this.expiration.equals(that.expiration));
    }

    public int hashCode() {
        int result = this.host != null ? this.host.hashCode() : 0;
        result = 31 * result + (this.ips != null ? Arrays.hashCode(this.ips) : 0);
        result = 31 * result + (this.expiration != null ? this.expiration.hashCode() : 0);
        return result;
    }
}

