/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dcm;

import com.alibaba.dcm.DnsCache;
import com.alibaba.dcm.DnsCacheEntry;
import com.alibaba.dcm.DnsCacheManipulatorException;
import com.alibaba.dcm.internal.InetAddressCacheUtil;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class DnsCacheManipulator {
    private static final long NEVER_EXPIRATION = Long.MAX_VALUE;
    private static Pattern COMMA_SEPARATOR = Pattern.compile("\\s*,\\s*");

    public static void setDnsCache(String host, String ... ips) {
        try {
            InetAddressCacheUtil.setInetAddressCache(host, ips, Long.MAX_VALUE);
        }
        catch (Exception e) {
            String message = String.format("Fail to setDnsCache for host %s ip %s, cause: %s", host, Arrays.toString(ips), e.toString());
            throw new DnsCacheManipulatorException(message, e);
        }
    }

    public static void setDnsCache(long expireMillis, String host, String ... ips) {
        try {
            InetAddressCacheUtil.setInetAddressCache(host, ips, System.currentTimeMillis() + expireMillis);
        }
        catch (Exception e) {
            String message = String.format("Fail to setDnsCache for host %s ip %s expireMillis %s, cause: %s", host, Arrays.toString(ips), expireMillis, e.toString());
            throw new DnsCacheManipulatorException(message, e);
        }
    }

    public static void setDnsCache(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String host = (String)entry.getKey();
            String ipList = (String)entry.getValue();
            if ((ipList = ipList.trim()).isEmpty()) continue;
            String[] ips = COMMA_SEPARATOR.split(ipList);
            DnsCacheManipulator.setDnsCache(host, ips);
        }
    }

    public static void loadDnsCacheConfig() {
        DnsCacheManipulator.loadDnsCacheConfig("dns-cache.properties");
    }

    public static void loadDnsCacheConfig(String propertiesFileName) {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(propertiesFileName);
        if (inputStream == null) {
            inputStream = DnsCacheManipulator.class.getClassLoader().getResourceAsStream(propertiesFileName);
        }
        if (inputStream == null) {
            throw new DnsCacheManipulatorException("Fail to find " + propertiesFileName + " on classpath!");
        }
        try {
            Properties properties = new Properties();
            properties.load(inputStream);
            inputStream.close();
            DnsCacheManipulator.setDnsCache(properties);
        }
        catch (Exception e) {
            String message = String.format("Fail to loadDnsCacheConfig from %s, cause: %s", propertiesFileName, e.toString());
            throw new DnsCacheManipulatorException(message, e);
        }
    }

    @Nullable
    public static DnsCacheEntry getDnsCache(String host) {
        try {
            return InetAddressCacheUtil.getInetAddressCache(host);
        }
        catch (Exception e) {
            throw new DnsCacheManipulatorException("Fail to getDnsCache, cause: " + e.toString(), e);
        }
    }

    @Deprecated
    public static List<DnsCacheEntry> getAllDnsCache() {
        return DnsCacheManipulator.listDnsCache();
    }

    public static List<DnsCacheEntry> listDnsCache() {
        try {
            return InetAddressCacheUtil.listInetAddressCache().getCache();
        }
        catch (Exception e) {
            throw new DnsCacheManipulatorException("Fail to listDnsCache, cause: " + e.toString(), e);
        }
    }

    public static DnsCache getWholeDnsCache() {
        try {
            return InetAddressCacheUtil.listInetAddressCache();
        }
        catch (Exception e) {
            throw new DnsCacheManipulatorException("Fail to getWholeDnsCache, cause: " + e.toString(), e);
        }
    }

    public static void removeDnsCache(String host) {
        try {
            InetAddressCacheUtil.removeInetAddressCache(host);
        }
        catch (Exception e) {
            String message = String.format("Fail to removeDnsCache for host %s, cause: %s", host, e.toString());
            throw new DnsCacheManipulatorException(message, e);
        }
    }

    public static void clearDnsCache() {
        try {
            InetAddressCacheUtil.clearInetAddressCache();
        }
        catch (Exception e) {
            throw new DnsCacheManipulatorException("Fail to clearDnsCache, cause: " + e.toString(), e);
        }
    }

    public static int getDnsCachePolicy() {
        try {
            return InetAddressCacheUtil.getDnsCachePolicy();
        }
        catch (Exception e) {
            throw new DnsCacheManipulatorException("Fail to getDnsCachePolicy, cause: " + e.toString(), e);
        }
    }

    public static void setDnsCachePolicy(int cacheSeconds) {
        try {
            InetAddressCacheUtil.setDnsCachePolicy(cacheSeconds);
        }
        catch (Exception e) {
            throw new DnsCacheManipulatorException("Fail to setDnsCachePolicy, cause: " + e.toString(), e);
        }
    }

    public static int getDnsNegativeCachePolicy() {
        try {
            return InetAddressCacheUtil.getDnsNegativeCachePolicy();
        }
        catch (Exception e) {
            throw new DnsCacheManipulatorException("Fail to getDnsNegativeCachePolicy, cause: " + e.toString(), e);
        }
    }

    public static void setDnsNegativeCachePolicy(int negativeCacheSeconds) {
        try {
            InetAddressCacheUtil.setDnsNegativeCachePolicy(negativeCacheSeconds);
        }
        catch (Exception e) {
            throw new DnsCacheManipulatorException("Fail to setDnsNegativeCachePolicy, cause: " + e.toString(), e);
        }
    }

    private DnsCacheManipulator() {
    }
}

