/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dcm.agent;

import com.alibaba.dcm.DnsCache;
import com.alibaba.dcm.DnsCacheEntry;
import com.alibaba.dcm.DnsCacheManipulator;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DcmAgent {
    static final String FILE = "file";
    static final String DCM_AGENT_SUCCESS_MARK_LINE = "!!DCM SUCCESS!!";
    static volatile Map<String, Method> action2Method;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void agentmain(String agentArgument) throws Exception {
        System.out.printf("%s: attached with agent argument: %s.\n", DcmAgent.class.getName(), agentArgument);
        agentArgument = agentArgument.trim();
        if (agentArgument.isEmpty()) {
            System.out.println(DcmAgent.class.getName() + ": agent argument is blank, do nothing!");
            return;
        }
        DcmAgent.initAction2Method();
        FileOutputStream fileOutputStream = null;
        try {
            Map<String, List<String>> action2Arguments = DcmAgent.parseAgentArgument(agentArgument);
            PrintWriter filePrinter = null;
            if (action2Arguments.containsKey(FILE)) {
                fileOutputStream = new FileOutputStream(action2Arguments.get(FILE).get(0), false);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
                filePrinter = new PrintWriter((Writer)outputStreamWriter, true);
                action2Arguments.remove(FILE);
            }
            if (action2Arguments.isEmpty()) {
                System.out.println(DcmAgent.class.getName() + ": No action in agent argument, do nothing!");
                if (filePrinter != null) {
                    filePrinter.printf("No action in agent argument, do nothing! agent argument: %s.\n", agentArgument);
                }
                return;
            }
            boolean allSuccess = true;
            for (Map.Entry<String, List<String>> entry : action2Arguments.entrySet()) {
                String action = entry.getKey();
                List<String> arguments = entry.getValue();
                String argumentString = DcmAgent.join(arguments);
                if (!action2Method.containsKey(action)) {
                    System.out.printf("%s: Unknown action %s, ignore! action: %<s %s!\n", DcmAgent.class.getName(), action, argumentString);
                    if (filePrinter == null) continue;
                    filePrinter.printf("Unknown action %s, ignore! action: %<s %s !\n", action, argumentString);
                    continue;
                }
                try {
                    Object result = DcmAgent.doAction(action, arguments.toArray(new String[0]));
                    DcmAgent.printResult(action, result, filePrinter);
                }
                catch (Exception e) {
                    allSuccess = false;
                    String exString = DcmAgent.throwable2StackString(e);
                    System.out.printf("%s: Error to do action %s %s, cause: %s\n", DcmAgent.class.getName(), action, argumentString, exString);
                    if (filePrinter == null) continue;
                    filePrinter.printf("Error to do action %s %s, cause: %s\n", action, argumentString, exString);
                }
            }
            if (allSuccess && filePrinter != null) {
                filePrinter.println(DCM_AGENT_SUCCESS_MARK_LINE);
            }
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Throwable e) {}
            }
        }
    }

    static Map<String, List<String>> parseAgentArgument(String argument) {
        String[] split = argument.split("\\s+");
        int idx = 0;
        HashMap<String, List<String>> action2Arguments = new HashMap<String, List<String>>();
        while (idx < split.length) {
            String action;
            if (!action2Method.containsKey(action = split[idx++])) continue;
            ArrayList<String> arguments = new ArrayList<String>();
            while (idx < split.length && !action2Method.containsKey(split[idx])) {
                arguments.add(split[idx++]);
            }
            action2Arguments.put(action, arguments);
        }
        return action2Arguments;
    }

    static String join(List<String> list) {
        return DcmAgent.join(list, " ");
    }

    static String join(List<String> list, String separator) {
        StringBuilder ret = new StringBuilder();
        for (String argument : list) {
            if (ret.length() > 0) {
                ret.append(separator);
            }
            ret.append(argument);
        }
        return ret.toString();
    }

    static Object doAction(String action, String[] arguments) throws Exception {
        Method method = action2Method.get(action);
        Class<?>[] parameterTypes = method.getParameterTypes();
        Object[] methodArgs = DcmAgent.convertStringArray2Arguments(action, arguments, parameterTypes);
        return method.invoke(null, methodArgs);
    }

    static Object[] convertStringArray2Arguments(String action, String[] arguments, Class<?>[] parameterTypes) {
        if (arguments.length < parameterTypes.length) {
            String message = String.format("action %s need more argument! arguments: %s", action, Arrays.toString(arguments));
            throw new IllegalStateException(message);
        }
        if (parameterTypes.length == 0) {
            return new Object[0];
        }
        Object[] methodArgs = new Object[parameterTypes.length];
        int lastArgumentIdx = parameterTypes.length - 1;
        if (parameterTypes[lastArgumentIdx] == String[].class) {
            String[] varArgs = new String[arguments.length - lastArgumentIdx];
            System.arraycopy(arguments, lastArgumentIdx, varArgs, 0, varArgs.length);
            methodArgs[lastArgumentIdx] = varArgs;
        } else if (arguments.length > parameterTypes.length) {
            String message = String.format("Too more arguments for Action %s! arguments: %s", action, Arrays.toString(arguments));
            throw new IllegalStateException(message);
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (methodArgs[i] != null) continue;
            Class<?> parameterType = parameterTypes[i];
            String argument = arguments[i];
            if (parameterType.equals(String.class)) {
                methodArgs[i] = argument;
                continue;
            }
            if (parameterType.equals(Integer.TYPE)) {
                methodArgs[i] = Integer.parseInt(argument);
                continue;
            }
            String message = String.format("Unexpected method type %s! Bug!!", parameterType.getName());
            throw new IllegalStateException(message);
        }
        return methodArgs;
    }

    static void printResult(String action, Object result, PrintWriter writer) {
        if (writer == null) {
            return;
        }
        Method method = action2Method.get(action);
        if (method.getReturnType() == Void.TYPE) {
            return;
        }
        if (result == null) {
            writer.println((Object)null);
        } else if (result instanceof DnsCacheEntry) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            DnsCacheEntry entry = (DnsCacheEntry)result;
            writer.printf("%s %s %s\n", entry.getHost(), DcmAgent.join(Arrays.asList(entry.getIps()), ","), dateFormat.format(entry.getExpiration()));
        } else if (result instanceof DnsCache) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            DnsCache dnsCache = (DnsCache)result;
            writer.println("Dns cache:");
            for (DnsCacheEntry entry : dnsCache.getCache()) {
                writer.printf("    %s %s %s\n", entry.getHost(), DcmAgent.join(Arrays.asList(entry.getIps()), ","), dateFormat.format(entry.getExpiration()));
            }
            writer.println("Dns negative cache: ");
            for (DnsCacheEntry entry : dnsCache.getNegativeCache()) {
                writer.printf("    %s %s %s\n", entry.getHost(), DcmAgent.join(Arrays.asList(entry.getIps()), ","), dateFormat.format(entry.getExpiration()));
            }
        } else {
            writer.println(result.toString());
        }
    }

    static String throwable2StackString(Throwable e) {
        StringWriter w = new StringWriter();
        e.printStackTrace(new PrintWriter((Writer)w, true));
        return w.toString();
    }

    static synchronized void initAction2Method() throws Exception {
        if (action2Method != null) {
            return;
        }
        HashMap<String, Method> map = new HashMap<String, Method>();
        map.put("set", DnsCacheManipulator.class.getMethod("setDnsCache", String.class, String[].class));
        map.put("get", DnsCacheManipulator.class.getMethod("getDnsCache", String.class));
        map.put("rm", DnsCacheManipulator.class.getMethod("removeDnsCache", String.class));
        map.put("list", DnsCacheManipulator.class.getMethod("getWholeDnsCache", new Class[0]));
        map.put("clear", DnsCacheManipulator.class.getMethod("clearDnsCache", new Class[0]));
        map.put("setPolicy", DnsCacheManipulator.class.getMethod("setDnsCachePolicy", Integer.TYPE));
        map.put("getPolicy", DnsCacheManipulator.class.getMethod("getDnsCachePolicy", new Class[0]));
        map.put("setNegativePolicy", DnsCacheManipulator.class.getMethod("setDnsNegativeCachePolicy", Integer.TYPE));
        map.put("getNegativePolicy", DnsCacheManipulator.class.getMethod("getDnsNegativeCachePolicy", new Class[0]));
        map.put(FILE, null);
        action2Method = map;
    }
}

