/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dcm.internal;

import com.alibaba.dcm.DnsCache;
import com.alibaba.dcm.DnsCacheEntry;
import com.alibaba.dcm.internal.IpParserUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import sun.net.InetAddressCachePolicy;

public class InetAddressCacheUtil {
    static volatile Object[] ADDRESS_CACHE_AND_NEGATIVE_CACHE = null;
    static volatile Field expirationFieldOfInetAddress$CacheEntry = null;
    static volatile Field addressesFieldOfInetAddress$CacheEntry = null;
    static volatile Field setFiled$InetAddressCachePolicy = null;
    static volatile Field negativeSet$InetAddressCachePolicy = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setInetAddressCache(String host, String[] ips, long expiration) throws NoSuchMethodException, UnknownHostException, IllegalAccessException, InstantiationException, InvocationTargetException, ClassNotFoundException, NoSuchFieldException {
        host = host.toLowerCase();
        Object entry = InetAddressCacheUtil.newCacheEntry(host, ips, expiration);
        Object object = InetAddressCacheUtil.getAddressCacheFieldOfInetAddress();
        synchronized (object) {
            InetAddressCacheUtil.getCacheFiledOfAddressCacheFiledOfInetAddress().put(host, entry);
            InetAddressCacheUtil.getCacheFiledOfNegativeCacheFiledOfInetAddress().remove(host);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeInetAddressCache(String host) throws NoSuchFieldException, IllegalAccessException {
        host = host.toLowerCase();
        Object object = InetAddressCacheUtil.getAddressCacheFieldOfInetAddress();
        synchronized (object) {
            InetAddressCacheUtil.getCacheFiledOfAddressCacheFiledOfInetAddress().remove(host);
            InetAddressCacheUtil.getCacheFiledOfNegativeCacheFiledOfInetAddress().remove(host);
        }
    }

    static Object newCacheEntry(String host, String[] ips, long expiration) throws UnknownHostException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        String className = "java.net.InetAddress$CacheEntry";
        Class<?> clazz = Class.forName(className);
        Constructor<?> constructor = clazz.getDeclaredConstructors()[0];
        constructor.setAccessible(true);
        return constructor.newInstance(InetAddressCacheUtil.toInetAddressArray(host, ips), expiration);
    }

    @GuardedBy(value="getAddressCacheFieldOfInetAddress()")
    static Map<String, Object> getCacheFiledOfAddressCacheFiledOfInetAddress() throws NoSuchFieldException, IllegalAccessException {
        return InetAddressCacheUtil.getCacheFiledOfInetAddress$Cache0(InetAddressCacheUtil.getAddressCacheFieldOfInetAddress());
    }

    @GuardedBy(value="getAddressCacheFieldOfInetAddress()")
    static Map<String, Object> getCacheFiledOfNegativeCacheFiledOfInetAddress() throws NoSuchFieldException, IllegalAccessException {
        return InetAddressCacheUtil.getCacheFiledOfInetAddress$Cache0(InetAddressCacheUtil.getNegativeCacheFieldOfInetAddress());
    }

    static Map<String, Object> getCacheFiledOfInetAddress$Cache0(Object inetAddressCache) throws NoSuchFieldException, IllegalAccessException {
        Class<?> clazz = inetAddressCache.getClass();
        Field cacheMapField = clazz.getDeclaredField("cache");
        cacheMapField.setAccessible(true);
        return (Map)cacheMapField.get(inetAddressCache);
    }

    static Object getAddressCacheFieldOfInetAddress() throws NoSuchFieldException, IllegalAccessException {
        return InetAddressCacheUtil.getAddressCacheFieldsOfInetAddress0()[0];
    }

    static Object getNegativeCacheFieldOfInetAddress() throws NoSuchFieldException, IllegalAccessException {
        return InetAddressCacheUtil.getAddressCacheFieldsOfInetAddress0()[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Object[] getAddressCacheFieldsOfInetAddress0() throws NoSuchFieldException, IllegalAccessException {
        if (ADDRESS_CACHE_AND_NEGATIVE_CACHE != null) return ADDRESS_CACHE_AND_NEGATIVE_CACHE;
        Class<InetAddressCacheUtil> clazz = InetAddressCacheUtil.class;
        synchronized (InetAddressCacheUtil.class) {
            if (ADDRESS_CACHE_AND_NEGATIVE_CACHE != null) return ADDRESS_CACHE_AND_NEGATIVE_CACHE;
            Field cacheField = InetAddress.class.getDeclaredField("addressCache");
            cacheField.setAccessible(true);
            Field negativeCacheField = InetAddress.class.getDeclaredField("negativeCache");
            negativeCacheField.setAccessible(true);
            ADDRESS_CACHE_AND_NEGATIVE_CACHE = new Object[]{cacheField.get(InetAddress.class), negativeCacheField.get(InetAddress.class)};
            // ** MonitorExit[var0] (shouldn't be in output)
            return ADDRESS_CACHE_AND_NEGATIVE_CACHE;
        }
    }

    static InetAddress[] toInetAddressArray(String host, String[] ips) throws UnknownHostException {
        InetAddress[] addresses = new InetAddress[ips.length];
        for (int i = 0; i < addresses.length; ++i) {
            addresses[i] = InetAddress.getByAddress(host, IpParserUtil.ip2ByteArray(ips[i]));
        }
        return addresses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static DnsCacheEntry getInetAddressCache(String host) throws NoSuchFieldException, IllegalAccessException {
        Object cacheEntry;
        host = host.toLowerCase();
        Object object = InetAddressCacheUtil.getAddressCacheFieldOfInetAddress();
        synchronized (object) {
            cacheEntry = InetAddressCacheUtil.getCacheFiledOfAddressCacheFiledOfInetAddress().get(host);
        }
        if (null == cacheEntry) {
            return null;
        }
        DnsCacheEntry dnsCacheEntry = InetAddressCacheUtil.inetAddress$CacheEntry2DnsCacheEntry(host, cacheEntry);
        if (InetAddressCacheUtil.isDnsCacheEntryExpired(dnsCacheEntry.getHost())) {
            return null;
        }
        return dnsCacheEntry;
    }

    static boolean isDnsCacheEntryExpired(String host) {
        return null == host || "0.0.0.0".equals(host);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DnsCache listInetAddressCache() throws NoSuchFieldException, IllegalAccessException {
        HashMap<String, Object> negativeCache;
        HashMap<String, Object> cache;
        Object object = InetAddressCacheUtil.getAddressCacheFieldOfInetAddress();
        synchronized (object) {
            cache = new HashMap<String, Object>(InetAddressCacheUtil.getCacheFiledOfAddressCacheFiledOfInetAddress());
            negativeCache = new HashMap<String, Object>(InetAddressCacheUtil.getCacheFiledOfNegativeCacheFiledOfInetAddress());
        }
        ArrayList<DnsCacheEntry> retCache = new ArrayList<DnsCacheEntry>();
        for (Map.Entry entry : cache.entrySet()) {
            String host = (String)entry.getKey();
            if (InetAddressCacheUtil.isDnsCacheEntryExpired(host)) continue;
            retCache.add(InetAddressCacheUtil.inetAddress$CacheEntry2DnsCacheEntry(host, entry.getValue()));
        }
        ArrayList<DnsCacheEntry> retNegativeCache = new ArrayList<DnsCacheEntry>();
        for (Map.Entry entry : negativeCache.entrySet()) {
            String host = (String)entry.getKey();
            retNegativeCache.add(InetAddressCacheUtil.inetAddress$CacheEntry2DnsCacheEntry(host, entry.getValue()));
        }
        return new DnsCache(retCache, retNegativeCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static DnsCacheEntry inetAddress$CacheEntry2DnsCacheEntry(String host, Object entry) throws NoSuchFieldException, IllegalAccessException {
        if (expirationFieldOfInetAddress$CacheEntry == null || addressesFieldOfInetAddress$CacheEntry == null) {
            Class<InetAddressCacheUtil> clazz = InetAddressCacheUtil.class;
            // MONITORENTER : com.alibaba.dcm.internal.InetAddressCacheUtil.class
            if (expirationFieldOfInetAddress$CacheEntry == null) {
                Field[] fields;
                Class<?> cacheEntryClass = entry.getClass();
                for (Field field : fields = cacheEntryClass.getDeclaredFields()) {
                    String name = field.getName();
                    if (name.equals("expiration")) {
                        field.setAccessible(true);
                        expirationFieldOfInetAddress$CacheEntry = field;
                        continue;
                    }
                    if (!name.startsWith("address")) throw new IllegalStateException("JDK add new Field " + name + " for class InetAddress.CacheEntry, report bug for dns-cache-manipulator lib!");
                    field.setAccessible(true);
                    addressesFieldOfInetAddress$CacheEntry = field;
                }
            }
            // MONITOREXIT : clazz
        }
        long expiration = (Long)expirationFieldOfInetAddress$CacheEntry.get(entry);
        InetAddress[] addresses = (InetAddress[])addressesFieldOfInetAddress$CacheEntry.get(entry);
        String[] ips = new String[addresses.length];
        int i = 0;
        while (i < addresses.length) {
            ips[i] = addresses[i].getHostAddress();
            ++i;
        }
        return new DnsCacheEntry(host, ips, new Date(expiration));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearInetAddressCache() throws NoSuchFieldException, IllegalAccessException {
        Object object = InetAddressCacheUtil.getAddressCacheFieldOfInetAddress();
        synchronized (object) {
            InetAddressCacheUtil.getCacheFiledOfAddressCacheFiledOfInetAddress().clear();
            InetAddressCacheUtil.getCacheFiledOfNegativeCacheFiledOfInetAddress().clear();
        }
    }

    public static void setDnsCachePolicy(int cacheSeconds) throws NoSuchFieldException, IllegalAccessException {
        InetAddressCacheUtil.setCachePolicy0(false, cacheSeconds);
    }

    public static int getDnsCachePolicy() throws NoSuchFieldException, IllegalAccessException {
        return InetAddressCachePolicy.get();
    }

    public static void setDnsNegativeCachePolicy(int negativeCacheSeconds) throws NoSuchFieldException, IllegalAccessException {
        InetAddressCacheUtil.setCachePolicy0(true, negativeCacheSeconds);
    }

    public static int getDnsNegativeCachePolicy() throws NoSuchFieldException, IllegalAccessException {
        return InetAddressCachePolicy.getNegative();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static void setCachePolicy0(boolean isNegative, int seconds) throws NoSuchFieldException, IllegalAccessException {
        Field setField;
        Class clazz;
        if (seconds < 0) {
            seconds = -1;
        }
        Class<InetAddressCachePolicy> clazz2 = InetAddressCachePolicy.class;
        Field cachePolicyFiled = clazz2.getDeclaredField(isNegative ? "negativeCachePolicy" : "cachePolicy");
        cachePolicyFiled.setAccessible(true);
        if (isNegative) {
            if (negativeSet$InetAddressCachePolicy == null) {
                clazz = InetAddressCacheUtil.class;
                // MONITORENTER : com.alibaba.dcm.internal.InetAddressCacheUtil.class
                if (negativeSet$InetAddressCachePolicy == null) {
                    try {
                        negativeSet$InetAddressCachePolicy = clazz2.getDeclaredField("propertyNegativeSet");
                    }
                    catch (NoSuchFieldException e) {
                        negativeSet$InetAddressCachePolicy = clazz2.getDeclaredField("negativeSet");
                    }
                    negativeSet$InetAddressCachePolicy.setAccessible(true);
                }
                // MONITOREXIT : clazz
            }
            setField = negativeSet$InetAddressCachePolicy;
        } else {
            if (setFiled$InetAddressCachePolicy == null) {
                clazz = InetAddressCacheUtil.class;
                // MONITORENTER : com.alibaba.dcm.internal.InetAddressCacheUtil.class
                if (setFiled$InetAddressCachePolicy == null) {
                    try {
                        setFiled$InetAddressCachePolicy = clazz2.getDeclaredField("propertySet");
                    }
                    catch (NoSuchFieldException e) {
                        setFiled$InetAddressCachePolicy = clazz2.getDeclaredField("set");
                    }
                    setFiled$InetAddressCachePolicy.setAccessible(true);
                }
                // MONITOREXIT : clazz
            }
            setField = setFiled$InetAddressCachePolicy;
        }
        clazz = InetAddressCachePolicy.class;
        // MONITORENTER : sun.net.InetAddressCachePolicy.class
        cachePolicyFiled.set(null, seconds);
        setField.set(null, true);
        // MONITOREXIT : clazz
    }

    private InetAddressCacheUtil() {
    }
}

