/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fescar.common.util;

import com.alibaba.fescar.common.exception.ShouldNeverHappenException;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.sql.Blob;
import javax.sql.rowset.serial.SerialBlob;

public class BlobUtils {
    private BlobUtils() {
    }

    public static Blob string2blob(String str) {
        if (str == null) {
            return null;
        }
        try {
            return new SerialBlob(str.getBytes());
        }
        catch (Exception e) {
            throw new ShouldNeverHappenException(e);
        }
    }

    public static String blob2string(Blob blob) {
        if (blob == null) {
            return null;
        }
        try {
            return new String(blob.getBytes(1L, (int)blob.length()));
        }
        catch (Exception e) {
            throw new ShouldNeverHappenException(e);
        }
    }

    public static String inputStream2String(InputStream is) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int i = -1;
            while ((i = is.read()) != -1) {
                baos.write(i);
            }
            return baos.toString();
        }
        catch (Exception e) {
            throw new ShouldNeverHappenException(e);
        }
    }
}

