/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.auth.credentials.provider;

import com.aliyun.auth.credentials.ICredential;
import com.aliyun.auth.credentials.provider.CredentialsProviderChain;
import com.aliyun.auth.credentials.provider.EnvironmentVariableCredentialProvider;
import com.aliyun.auth.credentials.provider.ICredentialProvider;
import com.aliyun.auth.credentials.provider.ProfileCredentialProvider;
import com.aliyun.auth.credentials.provider.SystemPropertiesCredentialProvider;
import com.aliyun.core.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class DefaultCredentialProvider
implements ICredentialProvider {
    private List<ICredentialProvider> customizeProviders;
    private final CredentialsProviderChain providerChain;

    private DefaultCredentialProvider(Builder builder) {
        this.customizeProviders = builder.customizeProviders;
        this.providerChain = this.createChain(builder);
    }

    private CredentialsProviderChain createChain(Builder builder) {
        boolean asyncCredentialUpdateEnabled = builder.asyncCredentialUpdateEnabled;
        boolean reuseLastProviderEnabled = builder.reuseLastProviderEnabled;
        if (this.customizeProviders.isEmpty()) {
            ICredentialProvider[] credentialsProviders = new ICredentialProvider[]{SystemPropertiesCredentialProvider.create(), EnvironmentVariableCredentialProvider.create(), ProfileCredentialProvider.builder().profileFile(builder.profileFile).clientType(builder.clientType).asyncCredentialUpdateEnabled(asyncCredentialUpdateEnabled).build()};
            this.customizeProviders = Arrays.asList(credentialsProviders);
        }
        return CredentialsProviderChain.builder().reuseLastProviderEnabled(reuseLastProviderEnabled).credentialsProviders(this.customizeProviders).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public ICredential getCredentials() {
        return this.providerChain.getCredentials();
    }

    public Boolean containsCredentialProvider(ICredentialProvider provider) {
        return this.customizeProviders.contains(provider);
    }

    public void close() {
        this.providerChain.close();
    }

    public String toString() {
        HashMap<String, CredentialsProviderChain> fieldMap = new HashMap<String, CredentialsProviderChain>();
        fieldMap.put("providerChain", this.providerChain);
        return StringUtils.toAliString((String)"DefaultCredentialsProvider", fieldMap);
    }

    public static final class Builder {
        private String profileFile;
        private String clientType;
        private Boolean reuseLastProviderEnabled = true;
        private Boolean asyncCredentialUpdateEnabled = false;
        private List<ICredentialProvider> customizeProviders = new ArrayList<ICredentialProvider>();

        public Builder profileFile(String profileFile) {
            this.profileFile = profileFile;
            return this;
        }

        public Builder clientType(String clientType) {
            this.clientType = clientType;
            return this;
        }

        public Builder reuseLastProviderEnabled(Boolean reuseLastProviderEnabled) {
            this.reuseLastProviderEnabled = reuseLastProviderEnabled;
            return this;
        }

        public Builder asyncCredentialUpdateEnabled(Boolean asyncCredentialUpdateEnabled) {
            this.asyncCredentialUpdateEnabled = asyncCredentialUpdateEnabled;
            return this;
        }

        public Builder customizeProviders(Collection<? extends ICredentialProvider> customizeProviders) {
            this.customizeProviders = new ArrayList<ICredentialProvider>(customizeProviders);
            return this;
        }

        public Builder customizeProviders(ICredentialProvider ... customizeProviders) {
            return this.customizeProviders(Arrays.asList(customizeProviders));
        }

        public Builder addCustomizeProviders(ICredentialProvider credentialsProviders) {
            this.customizeProviders.add(credentialsProviders);
            return this;
        }

        public DefaultCredentialProvider build() {
            return new DefaultCredentialProvider(this);
        }
    }
}

