/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.EnableMetricsCollectionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class EnableMetricsCollectionRequestMarshaller
implements Marshaller<Request<EnableMetricsCollectionRequest>, EnableMetricsCollectionRequest> {
    public Request<EnableMetricsCollectionRequest> marshall(EnableMetricsCollectionRequest enableMetricsCollectionRequest) {
        if (enableMetricsCollectionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)enableMetricsCollectionRequest, "AmazonAutoScaling");
        request.addParameter("Action", "EnableMetricsCollection");
        request.addParameter("Version", "2011-01-01");
        if (enableMetricsCollectionRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)enableMetricsCollectionRequest.getAutoScalingGroupName()));
        }
        List<String> metricsList = enableMetricsCollectionRequest.getMetrics();
        int metricsListIndex = 1;
        for (String metricsListValue : metricsList) {
            if (metricsListValue != null) {
                request.addParameter("Metrics.member." + metricsListIndex, StringUtils.fromString((String)metricsListValue));
            }
            ++metricsListIndex;
        }
        if (enableMetricsCollectionRequest.getGranularity() != null) {
            request.addParameter("Granularity", StringUtils.fromString((String)enableMetricsCollectionRequest.getGranularity()));
        }
        return request;
    }
}

