/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.alexaforbusiness;

import javax.annotation.Generated;

import com.amazonaws.services.alexaforbusiness.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonAlexaForBusiness}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonAlexaForBusiness implements AmazonAlexaForBusiness {

    protected AbstractAmazonAlexaForBusiness() {
    }

    @Override
    public ApproveSkillResult approveSkill(ApproveSkillRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociateContactWithAddressBookResult associateContactWithAddressBook(AssociateContactWithAddressBookRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociateDeviceWithNetworkProfileResult associateDeviceWithNetworkProfile(AssociateDeviceWithNetworkProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociateDeviceWithRoomResult associateDeviceWithRoom(AssociateDeviceWithRoomRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociateSkillGroupWithRoomResult associateSkillGroupWithRoom(AssociateSkillGroupWithRoomRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociateSkillWithSkillGroupResult associateSkillWithSkillGroup(AssociateSkillWithSkillGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociateSkillWithUsersResult associateSkillWithUsers(AssociateSkillWithUsersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAddressBookResult createAddressBook(CreateAddressBookRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateBusinessReportScheduleResult createBusinessReportSchedule(CreateBusinessReportScheduleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateConferenceProviderResult createConferenceProvider(CreateConferenceProviderRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateContactResult createContact(CreateContactRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateGatewayGroupResult createGatewayGroup(CreateGatewayGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateNetworkProfileResult createNetworkProfile(CreateNetworkProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateProfileResult createProfile(CreateProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateRoomResult createRoom(CreateRoomRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSkillGroupResult createSkillGroup(CreateSkillGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateUserResult createUser(CreateUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAddressBookResult deleteAddressBook(DeleteAddressBookRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteBusinessReportScheduleResult deleteBusinessReportSchedule(DeleteBusinessReportScheduleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteConferenceProviderResult deleteConferenceProvider(DeleteConferenceProviderRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteContactResult deleteContact(DeleteContactRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDeviceResult deleteDevice(DeleteDeviceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDeviceUsageDataResult deleteDeviceUsageData(DeleteDeviceUsageDataRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteGatewayGroupResult deleteGatewayGroup(DeleteGatewayGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteNetworkProfileResult deleteNetworkProfile(DeleteNetworkProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteProfileResult deleteProfile(DeleteProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteRoomResult deleteRoom(DeleteRoomRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteRoomSkillParameterResult deleteRoomSkillParameter(DeleteRoomSkillParameterRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteSkillAuthorizationResult deleteSkillAuthorization(DeleteSkillAuthorizationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteSkillGroupResult deleteSkillGroup(DeleteSkillGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteUserResult deleteUser(DeleteUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateContactFromAddressBookResult disassociateContactFromAddressBook(DisassociateContactFromAddressBookRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateDeviceFromRoomResult disassociateDeviceFromRoom(DisassociateDeviceFromRoomRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateSkillFromSkillGroupResult disassociateSkillFromSkillGroup(DisassociateSkillFromSkillGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateSkillFromUsersResult disassociateSkillFromUsers(DisassociateSkillFromUsersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateSkillGroupFromRoomResult disassociateSkillGroupFromRoom(DisassociateSkillGroupFromRoomRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ForgetSmartHomeAppliancesResult forgetSmartHomeAppliances(ForgetSmartHomeAppliancesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAddressBookResult getAddressBook(GetAddressBookRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetConferencePreferenceResult getConferencePreference(GetConferencePreferenceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetConferenceProviderResult getConferenceProvider(GetConferenceProviderRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetContactResult getContact(GetContactRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDeviceResult getDevice(GetDeviceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetGatewayResult getGateway(GetGatewayRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetGatewayGroupResult getGatewayGroup(GetGatewayGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetInvitationConfigurationResult getInvitationConfiguration(GetInvitationConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetNetworkProfileResult getNetworkProfile(GetNetworkProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetProfileResult getProfile(GetProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetRoomResult getRoom(GetRoomRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetRoomSkillParameterResult getRoomSkillParameter(GetRoomSkillParameterRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSkillGroupResult getSkillGroup(GetSkillGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListBusinessReportSchedulesResult listBusinessReportSchedules(ListBusinessReportSchedulesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListConferenceProvidersResult listConferenceProviders(ListConferenceProvidersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDeviceEventsResult listDeviceEvents(ListDeviceEventsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListGatewayGroupsResult listGatewayGroups(ListGatewayGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListGatewaysResult listGateways(ListGatewaysRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSkillsResult listSkills(ListSkillsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSkillsStoreCategoriesResult listSkillsStoreCategories(ListSkillsStoreCategoriesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSkillsStoreSkillsByCategoryResult listSkillsStoreSkillsByCategory(ListSkillsStoreSkillsByCategoryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSmartHomeAppliancesResult listSmartHomeAppliances(ListSmartHomeAppliancesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsResult listTags(ListTagsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutConferencePreferenceResult putConferencePreference(PutConferencePreferenceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutInvitationConfigurationResult putInvitationConfiguration(PutInvitationConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutRoomSkillParameterResult putRoomSkillParameter(PutRoomSkillParameterRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutSkillAuthorizationResult putSkillAuthorization(PutSkillAuthorizationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RegisterAVSDeviceResult registerAVSDevice(RegisterAVSDeviceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RejectSkillResult rejectSkill(RejectSkillRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ResolveRoomResult resolveRoom(ResolveRoomRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RevokeInvitationResult revokeInvitation(RevokeInvitationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchAddressBooksResult searchAddressBooks(SearchAddressBooksRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchContactsResult searchContacts(SearchContactsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchDevicesResult searchDevices(SearchDevicesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchNetworkProfilesResult searchNetworkProfiles(SearchNetworkProfilesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchProfilesResult searchProfiles(SearchProfilesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchRoomsResult searchRooms(SearchRoomsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchSkillGroupsResult searchSkillGroups(SearchSkillGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchUsersResult searchUsers(SearchUsersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SendAnnouncementResult sendAnnouncement(SendAnnouncementRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SendInvitationResult sendInvitation(SendInvitationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartDeviceSyncResult startDeviceSync(StartDeviceSyncRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartSmartHomeApplianceDiscoveryResult startSmartHomeApplianceDiscovery(StartSmartHomeApplianceDiscoveryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAddressBookResult updateAddressBook(UpdateAddressBookRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateBusinessReportScheduleResult updateBusinessReportSchedule(UpdateBusinessReportScheduleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateConferenceProviderResult updateConferenceProvider(UpdateConferenceProviderRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateContactResult updateContact(UpdateContactRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDeviceResult updateDevice(UpdateDeviceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateGatewayResult updateGateway(UpdateGatewayRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateGatewayGroupResult updateGatewayGroup(UpdateGatewayGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateNetworkProfileResult updateNetworkProfile(UpdateNetworkProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateProfileResult updateProfile(UpdateProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateRoomResult updateRoom(UpdateRoomRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateSkillGroupResult updateSkillGroup(UpdateSkillGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
