/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.apigatewayv2;

import javax.annotation.Generated;

import com.amazonaws.services.apigatewayv2.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonApiGatewayV2}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonApiGatewayV2 implements AmazonApiGatewayV2 {

    protected AbstractAmazonApiGatewayV2() {
    }

    @Override
    public CreateApiResult createApi(CreateApiRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateApiMappingResult createApiMapping(CreateApiMappingRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAuthorizerResult createAuthorizer(CreateAuthorizerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDeploymentResult createDeployment(CreateDeploymentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDomainNameResult createDomainName(CreateDomainNameRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateIntegrationResult createIntegration(CreateIntegrationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateIntegrationResponseResult createIntegrationResponse(CreateIntegrationResponseRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateModelResult createModel(CreateModelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateRouteResult createRoute(CreateRouteRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateRouteResponseResult createRouteResponse(CreateRouteResponseRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateStageResult createStage(CreateStageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateVpcLinkResult createVpcLink(CreateVpcLinkRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAccessLogSettingsResult deleteAccessLogSettings(DeleteAccessLogSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteApiResult deleteApi(DeleteApiRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteApiMappingResult deleteApiMapping(DeleteApiMappingRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAuthorizerResult deleteAuthorizer(DeleteAuthorizerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteCorsConfigurationResult deleteCorsConfiguration(DeleteCorsConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDeploymentResult deleteDeployment(DeleteDeploymentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDomainNameResult deleteDomainName(DeleteDomainNameRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteIntegrationResult deleteIntegration(DeleteIntegrationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteIntegrationResponseResult deleteIntegrationResponse(DeleteIntegrationResponseRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteModelResult deleteModel(DeleteModelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteRouteResult deleteRoute(DeleteRouteRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteRouteRequestParameterResult deleteRouteRequestParameter(DeleteRouteRequestParameterRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteRouteResponseResult deleteRouteResponse(DeleteRouteResponseRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteRouteSettingsResult deleteRouteSettings(DeleteRouteSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteStageResult deleteStage(DeleteStageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteVpcLinkResult deleteVpcLink(DeleteVpcLinkRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ExportApiResult exportApi(ExportApiRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetApiResult getApi(GetApiRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetApiMappingResult getApiMapping(GetApiMappingRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetApiMappingsResult getApiMappings(GetApiMappingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetApisResult getApis(GetApisRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAuthorizerResult getAuthorizer(GetAuthorizerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAuthorizersResult getAuthorizers(GetAuthorizersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDeploymentResult getDeployment(GetDeploymentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDeploymentsResult getDeployments(GetDeploymentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDomainNameResult getDomainName(GetDomainNameRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDomainNamesResult getDomainNames(GetDomainNamesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetIntegrationResult getIntegration(GetIntegrationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetIntegrationResponseResult getIntegrationResponse(GetIntegrationResponseRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetIntegrationResponsesResult getIntegrationResponses(GetIntegrationResponsesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetIntegrationsResult getIntegrations(GetIntegrationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetModelResult getModel(GetModelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetModelTemplateResult getModelTemplate(GetModelTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetModelsResult getModels(GetModelsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetRouteResult getRoute(GetRouteRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetRouteResponseResult getRouteResponse(GetRouteResponseRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetRouteResponsesResult getRouteResponses(GetRouteResponsesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetRoutesResult getRoutes(GetRoutesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetStageResult getStage(GetStageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetStagesResult getStages(GetStagesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTagsResult getTags(GetTagsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetVpcLinkResult getVpcLink(GetVpcLinkRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetVpcLinksResult getVpcLinks(GetVpcLinksRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ImportApiResult importApi(ImportApiRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ReimportApiResult reimportApi(ReimportApiRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ResetAuthorizersCacheResult resetAuthorizersCache(ResetAuthorizersCacheRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateApiResult updateApi(UpdateApiRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateApiMappingResult updateApiMapping(UpdateApiMappingRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAuthorizerResult updateAuthorizer(UpdateAuthorizerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDeploymentResult updateDeployment(UpdateDeploymentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDomainNameResult updateDomainName(UpdateDomainNameRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateIntegrationResult updateIntegration(UpdateIntegrationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateIntegrationResponseResult updateIntegrationResponse(UpdateIntegrationResponseRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateModelResult updateModel(UpdateModelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateRouteResult updateRoute(UpdateRouteRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateRouteResponseResult updateRouteResponse(UpdateRouteResponseRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateStageResult updateStage(UpdateStageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateVpcLinkResult updateVpcLink(UpdateVpcLinkRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
