/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.glue.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * A structure for a machine learning transform.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/MLTransform" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class MLTransform implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The unique transform ID that is generated for the machine learning transform. The ID is guaranteed to be unique
     * and does not change.
     * </p>
     */
    private String transformId;
    /**
     * <p>
     * A user-defined name for the machine learning transform. Names are not guaranteed unique and can be changed at any
     * time.
     * </p>
     */
    private String name;
    /**
     * <p>
     * A user-defined, long-form description text for the machine learning transform. Descriptions are not guaranteed to
     * be unique and can be changed at any time.
     * </p>
     */
    private String description;
    /**
     * <p>
     * The current status of the machine learning transform.
     * </p>
     */
    private String status;
    /**
     * <p>
     * A timestamp. The time and date that this machine learning transform was created.
     * </p>
     */
    private java.util.Date createdOn;
    /**
     * <p>
     * A timestamp. The last point in time when this machine learning transform was modified.
     * </p>
     */
    private java.util.Date lastModifiedOn;
    /**
     * <p>
     * A list of AWS Glue table definitions used by the transform.
     * </p>
     */
    private java.util.List<GlueTable> inputRecordTables;
    /**
     * <p>
     * A <code>TransformParameters</code> object. You can use parameters to tune (customize) the behavior of the machine
     * learning transform by specifying what data it learns from and your preference on various tradeoffs (such as
     * precious vs. recall, or accuracy vs. cost).
     * </p>
     */
    private TransformParameters parameters;
    /**
     * <p>
     * An <code>EvaluationMetrics</code> object. Evaluation metrics provide an estimate of the quality of your machine
     * learning transform.
     * </p>
     */
    private EvaluationMetrics evaluationMetrics;
    /**
     * <p>
     * A count identifier for the labeling files generated by AWS Glue for this transform. As you create a better
     * transform, you can iteratively download, label, and upload the labeling file.
     * </p>
     */
    private Integer labelCount;
    /**
     * <p>
     * A map of key-value pairs representing the columns and data types that this transform can run against. Has an
     * upper bound of 100 columns.
     * </p>
     */
    private java.util.List<SchemaColumn> schema;
    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the IAM role with the required permissions. The required permissions
     * include both AWS Glue service role permissions to AWS Glue resources, and Amazon S3 permissions required by the
     * transform.
     * </p>
     * <ul>
     * <li>
     * <p>
     * This role needs AWS Glue service role permissions to allow access to resources in AWS Glue. See <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/attach-policy-iam-user.html">Attach a Policy to IAM Users That
     * Access AWS Glue</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * This role needs permission to your Amazon Simple Storage Service (Amazon S3) sources, targets, temporary
     * directory, scripts, and any libraries used by the task run for this transform.
     * </p>
     * </li>
     * </ul>
     */
    private String role;
    /**
     * <p>
     * This value determines which version of AWS Glue this machine learning transform is compatible with. Glue 1.0 is
     * recommended for most customers. If the value is not set, the Glue compatibility defaults to Glue 0.9. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions">AWS Glue Versions</a>
     * in the developer guide.
     * </p>
     */
    private String glueVersion;
    /**
     * <p>
     * The number of AWS Glue data processing units (DPUs) that are allocated to task runs for this transform. You can
     * allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of processing power that consists of
     * 4 vCPUs of compute capacity and 16 GB of memory. For more information, see the <a
     * href="http://aws.amazon.com/glue/pricing/">AWS Glue pricing page</a>.
     * </p>
     * <p>
     * <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and
     * <code>WorkerType</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code> cannot be
     * set.
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code> can be
     * set.
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When the <code>WorkerType</code> field is set to a value other than <code>Standard</code>, the
     * <code>MaxCapacity</code> field is set automatically and becomes read-only.
     * </p>
     */
    private Double maxCapacity;
    /**
     * <p>
     * The type of predefined worker that is allocated when a task of this transform runs. Accepts a value of Standard,
     * G.1X, or G.2X.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2
     * executors per worker.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1
     * executor per worker.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and 1
     * executor per worker.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and
     * <code>WorkerType</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code> cannot be
     * set.
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code> can be
     * set.
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.
     * </p>
     * </li>
     * </ul>
     */
    private String workerType;
    /**
     * <p>
     * The number of workers of a defined <code>workerType</code> that are allocated when a task of the transform runs.
     * </p>
     * <p>
     * If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).
     * </p>
     */
    private Integer numberOfWorkers;
    /**
     * <p>
     * The timeout in minutes of the machine learning transform.
     * </p>
     */
    private Integer timeout;
    /**
     * <p>
     * The maximum number of times to retry after an <code>MLTaskRun</code> of the machine learning transform fails.
     * </p>
     */
    private Integer maxRetries;
    /**
     * <p>
     * The encryption-at-rest settings of the transform that apply to accessing user data. Machine learning transforms
     * can access user data encrypted in Amazon S3 using KMS.
     * </p>
     */
    private TransformEncryption transformEncryption;

    /**
     * <p>
     * The unique transform ID that is generated for the machine learning transform. The ID is guaranteed to be unique
     * and does not change.
     * </p>
     * 
     * @param transformId
     *        The unique transform ID that is generated for the machine learning transform. The ID is guaranteed to be
     *        unique and does not change.
     */

    public void setTransformId(String transformId) {
        this.transformId = transformId;
    }

    /**
     * <p>
     * The unique transform ID that is generated for the machine learning transform. The ID is guaranteed to be unique
     * and does not change.
     * </p>
     * 
     * @return The unique transform ID that is generated for the machine learning transform. The ID is guaranteed to be
     *         unique and does not change.
     */

    public String getTransformId() {
        return this.transformId;
    }

    /**
     * <p>
     * The unique transform ID that is generated for the machine learning transform. The ID is guaranteed to be unique
     * and does not change.
     * </p>
     * 
     * @param transformId
     *        The unique transform ID that is generated for the machine learning transform. The ID is guaranteed to be
     *        unique and does not change.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MLTransform withTransformId(String transformId) {
        setTransformId(transformId);
        return this;
    }

    /**
     * <p>
     * A user-defined name for the machine learning transform. Names are not guaranteed unique and can be changed at any
     * time.
     * </p>
     * 
     * @param name
     *        A user-defined name for the machine learning transform. Names are not guaranteed unique and can be changed
     *        at any time.
     */

    public void setName(String name) {
        this.name = name;
    }

    /**
     * <p>
     * A user-defined name for the machine learning transform. Names are not guaranteed unique and can be changed at any
     * time.
     * </p>
     * 
     * @return A user-defined name for the machine learning transform. Names are not guaranteed unique and can be
     *         changed at any time.
     */

    public String getName() {
        return this.name;
    }

    /**
     * <p>
     * A user-defined name for the machine learning transform. Names are not guaranteed unique and can be changed at any
     * time.
     * </p>
     * 
     * @param name
     *        A user-defined name for the machine learning transform. Names are not guaranteed unique and can be changed
     *        at any time.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MLTransform withName(String name) {
        setName(name);
        return this;
    }

    /**
     * <p>
     * A user-defined, long-form description text for the machine learning transform. Descriptions are not guaranteed to
     * be unique and can be changed at any time.
     * </p>
     * 
     * @param description
     *        A user-defined, long-form description text for the machine learning transform. Descriptions are not
     *        guaranteed to be unique and can be changed at any time.
     */

    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * <p>
     * A user-defined, long-form description text for the machine learning transform. Descriptions are not guaranteed to
     * be unique and can be changed at any time.
     * </p>
     * 
     * @return A user-defined, long-form description text for the machine learning transform. Descriptions are not
     *         guaranteed to be unique and can be changed at any time.
     */

    public String getDescription() {
        return this.description;
    }

    /**
     * <p>
     * A user-defined, long-form description text for the machine learning transform. Descriptions are not guaranteed to
     * be unique and can be changed at any time.
     * </p>
     * 
     * @param description
     *        A user-defined, long-form description text for the machine learning transform. Descriptions are not
     *        guaranteed to be unique and can be changed at any time.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MLTransform withDescription(String description) {
        setDescription(description);
        return this;
    }

    /**
     * <p>
     * The current status of the machine learning transform.
     * </p>
     * 
     * @param status
     *        The current status of the machine learning transform.
     * @see TransformStatusType
     */

    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * <p>
     * The current status of the machine learning transform.
     * </p>
     * 
     * @return The current status of the machine learning transform.
     * @see TransformStatusType
     */

    public String getStatus() {
        return this.status;
    }

    /**
     * <p>
     * The current status of the machine learning transform.
     * </p>
     * 
     * @param status
     *        The current status of the machine learning transform.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see TransformStatusType
     */

    public MLTransform withStatus(String status) {
        setStatus(status);
        return this;
    }

    /**
     * <p>
     * The current status of the machine learning transform.
     * </p>
     * 
     * @param status
     *        The current status of the machine learning transform.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see TransformStatusType
     */

    public MLTransform withStatus(TransformStatusType status) {
        this.status = status.toString();
        return this;
    }

    /**
     * <p>
     * A timestamp. The time and date that this machine learning transform was created.
     * </p>
     * 
     * @param createdOn
     *        A timestamp. The time and date that this machine learning transform was created.
     */

    public void setCreatedOn(java.util.Date createdOn) {
        this.createdOn = createdOn;
    }

    /**
     * <p>
     * A timestamp. The time and date that this machine learning transform was created.
     * </p>
     * 
     * @return A timestamp. The time and date that this machine learning transform was created.
     */

    public java.util.Date getCreatedOn() {
        return this.createdOn;
    }

    /**
     * <p>
     * A timestamp. The time and date that this machine learning transform was created.
     * </p>
     * 
     * @param createdOn
     *        A timestamp. The time and date that this machine learning transform was created.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MLTransform withCreatedOn(java.util.Date createdOn) {
        setCreatedOn(createdOn);
        return this;
    }

    /**
     * <p>
     * A timestamp. The last point in time when this machine learning transform was modified.
     * </p>
     * 
     * @param lastModifiedOn
     *        A timestamp. The last point in time when this machine learning transform was modified.
     */

    public void setLastModifiedOn(java.util.Date lastModifiedOn) {
        this.lastModifiedOn = lastModifiedOn;
    }

    /**
     * <p>
     * A timestamp. The last point in time when this machine learning transform was modified.
     * </p>
     * 
     * @return A timestamp. The last point in time when this machine learning transform was modified.
     */

    public java.util.Date getLastModifiedOn() {
        return this.lastModifiedOn;
    }

    /**
     * <p>
     * A timestamp. The last point in time when this machine learning transform was modified.
     * </p>
     * 
     * @param lastModifiedOn
     *        A timestamp. The last point in time when this machine learning transform was modified.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MLTransform withLastModifiedOn(java.util.Date lastModifiedOn) {
        setLastModifiedOn(lastModifiedOn);
        return this;
    }

    /**
     * <p>
     * A list of AWS Glue table definitions used by the transform.
     * </p>
     * 
     * @return A list of AWS Glue table definitions used by the transform.
     */

    public java.util.List<GlueTable> getInputRecordTables() {
        return inputRecordTables;
    }

    /**
     * <p>
     * A list of AWS Glue table definitions used by the transform.
     * </p>
     * 
     * @param inputRecordTables
     *        A list of AWS Glue table definitions used by the transform.
     */

    public void setInputRecordTables(java.util.Collection<GlueTable> inputRecordTables) {
        if (inputRecordTables == null) {
            this.inputRecordTables = null;
            return;
        }

        this.inputRecordTables = new java.util.ArrayList<GlueTable>(inputRecordTables);
    }

    /**
     * <p>
     * A list of AWS Glue table definitions used by the transform.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setInputRecordTables(java.util.Collection)} or {@link #withInputRecordTables(java.util.Collection)} if
     * you want to override the existing values.
     * </p>
     * 
     * @param inputRecordTables
     *        A list of AWS Glue table definitions used by the transform.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MLTransform withInputRecordTables(GlueTable... inputRecordTables) {
        if (this.inputRecordTables == null) {
            setInputRecordTables(new java.util.ArrayList<GlueTable>(inputRecordTables.length));
        }
        for (GlueTable ele : inputRecordTables) {
            this.inputRecordTables.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of AWS Glue table definitions used by the transform.
     * </p>
     * 
     * @param inputRecordTables
     *        A list of AWS Glue table definitions used by the transform.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MLTransform withInputRecordTables(java.util.Collection<GlueTable> inputRecordTables) {
        setInputRecordTables(inputRecordTables);
        return this;
    }

    /**
     * <p>
     * A <code>TransformParameters</code> object. You can use parameters to tune (customize) the behavior of the machine
     * learning transform by specifying what data it learns from and your preference on various tradeoffs (such as
     * precious vs. recall, or accuracy vs. cost).
     * </p>
     * 
     * @param parameters
     *        A <code>TransformParameters</code> object. You can use parameters to tune (customize) the behavior of the
     *        machine learning transform by specifying what data it learns from and your preference on various tradeoffs
     *        (such as precious vs. recall, or accuracy vs. cost).
     */

    public void setParameters(TransformParameters parameters) {
        this.parameters = parameters;
    }

    /**
     * <p>
     * A <code>TransformParameters</code> object. You can use parameters to tune (customize) the behavior of the machine
     * learning transform by specifying what data it learns from and your preference on various tradeoffs (such as
     * precious vs. recall, or accuracy vs. cost).
     * </p>
     * 
     * @return A <code>TransformParameters</code> object. You can use parameters to tune (customize) the behavior of the
     *         machine learning transform by specifying what data it learns from and your preference on various
     *         tradeoffs (such as precious vs. recall, or accuracy vs. cost).
     */

    public TransformParameters getParameters() {
        return this.parameters;
    }

    /**
     * <p>
     * A <code>TransformParameters</code> object. You can use parameters to tune (customize) the behavior of the machine
     * learning transform by specifying what data it learns from and your preference on various tradeoffs (such as
     * precious vs. recall, or accuracy vs. cost).
     * </p>
     * 
     * @param parameters
     *        A <code>TransformParameters</code> object. You can use parameters to tune (customize) the behavior of the
     *        machine learning transform by specifying what data it learns from and your preference on various tradeoffs
     *        (such as precious vs. recall, or accuracy vs. cost).
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MLTransform withParameters(TransformParameters parameters) {
        setParameters(parameters);
        return this;
    }

    /**
     * <p>
     * An <code>EvaluationMetrics</code> object. Evaluation metrics provide an estimate of the quality of your machine
     * learning transform.
     * </p>
     * 
     * @param evaluationMetrics
     *        An <code>EvaluationMetrics</code> object. Evaluation metrics provide an estimate of the quality of your
     *        machine learning transform.
     */

    public void setEvaluationMetrics(EvaluationMetrics evaluationMetrics) {
        this.evaluationMetrics = evaluationMetrics;
    }

    /**
     * <p>
     * An <code>EvaluationMetrics</code> object. Evaluation metrics provide an estimate of the quality of your machine
     * learning transform.
     * </p>
     * 
     * @return An <code>EvaluationMetrics</code> object. Evaluation metrics provide an estimate of the quality of your
     *         machine learning transform.
     */

    public EvaluationMetrics getEvaluationMetrics() {
        return this.evaluationMetrics;
    }

    /**
     * <p>
     * An <code>EvaluationMetrics</code> object. Evaluation metrics provide an estimate of the quality of your machine
     * learning transform.
     * </p>
     * 
     * @param evaluationMetrics
     *        An <code>EvaluationMetrics</code> object. Evaluation metrics provide an estimate of the quality of your
     *        machine learning transform.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MLTransform withEvaluationMetrics(EvaluationMetrics evaluationMetrics) {
        setEvaluationMetrics(evaluationMetrics);
        return this;
    }

    /**
     * <p>
     * A count identifier for the labeling files generated by AWS Glue for this transform. As you create a better
     * transform, you can iteratively download, label, and upload the labeling file.
     * </p>
     * 
     * @param labelCount
     *        A count identifier for the labeling files generated by AWS Glue for this transform. As you create a better
     *        transform, you can iteratively download, label, and upload the labeling file.
     */

    public void setLabelCount(Integer labelCount) {
        this.labelCount = labelCount;
    }

    /**
     * <p>
     * A count identifier for the labeling files generated by AWS Glue for this transform. As you create a better
     * transform, you can iteratively download, label, and upload the labeling file.
     * </p>
     * 
     * @return A count identifier for the labeling files generated by AWS Glue for this transform. As you create a
     *         better transform, you can iteratively download, label, and upload the labeling file.
     */

    public Integer getLabelCount() {
        return this.labelCount;
    }

    /**
     * <p>
     * A count identifier for the labeling files generated by AWS Glue for this transform. As you create a better
     * transform, you can iteratively download, label, and upload the labeling file.
     * </p>
     * 
     * @param labelCount
     *        A count identifier for the labeling files generated by AWS Glue for this transform. As you create a better
     *        transform, you can iteratively download, label, and upload the labeling file.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MLTransform withLabelCount(Integer labelCount) {
        setLabelCount(labelCount);
        return this;
    }

    /**
     * <p>
     * A map of key-value pairs representing the columns and data types that this transform can run against. Has an
     * upper bound of 100 columns.
     * </p>
     * 
     * @return A map of key-value pairs representing the columns and data types that this transform can run against. Has
     *         an upper bound of 100 columns.
     */

    public java.util.List<SchemaColumn> getSchema() {
        return schema;
    }

    /**
     * <p>
     * A map of key-value pairs representing the columns and data types that this transform can run against. Has an
     * upper bound of 100 columns.
     * </p>
     * 
     * @param schema
     *        A map of key-value pairs representing the columns and data types that this transform can run against. Has
     *        an upper bound of 100 columns.
     */

    public void setSchema(java.util.Collection<SchemaColumn> schema) {
        if (schema == null) {
            this.schema = null;
            return;
        }

        this.schema = new java.util.ArrayList<SchemaColumn>(schema);
    }

    /**
     * <p>
     * A map of key-value pairs representing the columns and data types that this transform can run against. Has an
     * upper bound of 100 columns.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setSchema(java.util.Collection)} or {@link #withSchema(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param schema
     *        A map of key-value pairs representing the columns and data types that this transform can run against. Has
     *        an upper bound of 100 columns.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MLTransform withSchema(SchemaColumn... schema) {
        if (this.schema == null) {
            setSchema(new java.util.ArrayList<SchemaColumn>(schema.length));
        }
        for (SchemaColumn ele : schema) {
            this.schema.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A map of key-value pairs representing the columns and data types that this transform can run against. Has an
     * upper bound of 100 columns.
     * </p>
     * 
     * @param schema
     *        A map of key-value pairs representing the columns and data types that this transform can run against. Has
     *        an upper bound of 100 columns.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MLTransform withSchema(java.util.Collection<SchemaColumn> schema) {
        setSchema(schema);
        return this;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the IAM role with the required permissions. The required permissions
     * include both AWS Glue service role permissions to AWS Glue resources, and Amazon S3 permissions required by the
     * transform.
     * </p>
     * <ul>
     * <li>
     * <p>
     * This role needs AWS Glue service role permissions to allow access to resources in AWS Glue. See <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/attach-policy-iam-user.html">Attach a Policy to IAM Users That
     * Access AWS Glue</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * This role needs permission to your Amazon Simple Storage Service (Amazon S3) sources, targets, temporary
     * directory, scripts, and any libraries used by the task run for this transform.
     * </p>
     * </li>
     * </ul>
     * 
     * @param role
     *        The name or Amazon Resource Name (ARN) of the IAM role with the required permissions. The required
     *        permissions include both AWS Glue service role permissions to AWS Glue resources, and Amazon S3
     *        permissions required by the transform. </p>
     *        <ul>
     *        <li>
     *        <p>
     *        This role needs AWS Glue service role permissions to allow access to resources in AWS Glue. See <a
     *        href="https://docs.aws.amazon.com/glue/latest/dg/attach-policy-iam-user.html">Attach a Policy to IAM Users
     *        That Access AWS Glue</a>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        This role needs permission to your Amazon Simple Storage Service (Amazon S3) sources, targets, temporary
     *        directory, scripts, and any libraries used by the task run for this transform.
     *        </p>
     *        </li>
     */

    public void setRole(String role) {
        this.role = role;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the IAM role with the required permissions. The required permissions
     * include both AWS Glue service role permissions to AWS Glue resources, and Amazon S3 permissions required by the
     * transform.
     * </p>
     * <ul>
     * <li>
     * <p>
     * This role needs AWS Glue service role permissions to allow access to resources in AWS Glue. See <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/attach-policy-iam-user.html">Attach a Policy to IAM Users That
     * Access AWS Glue</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * This role needs permission to your Amazon Simple Storage Service (Amazon S3) sources, targets, temporary
     * directory, scripts, and any libraries used by the task run for this transform.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name or Amazon Resource Name (ARN) of the IAM role with the required permissions. The required
     *         permissions include both AWS Glue service role permissions to AWS Glue resources, and Amazon S3
     *         permissions required by the transform. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         This role needs AWS Glue service role permissions to allow access to resources in AWS Glue. See <a
     *         href="https://docs.aws.amazon.com/glue/latest/dg/attach-policy-iam-user.html">Attach a Policy to IAM
     *         Users That Access AWS Glue</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         This role needs permission to your Amazon Simple Storage Service (Amazon S3) sources, targets, temporary
     *         directory, scripts, and any libraries used by the task run for this transform.
     *         </p>
     *         </li>
     */

    public String getRole() {
        return this.role;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the IAM role with the required permissions. The required permissions
     * include both AWS Glue service role permissions to AWS Glue resources, and Amazon S3 permissions required by the
     * transform.
     * </p>
     * <ul>
     * <li>
     * <p>
     * This role needs AWS Glue service role permissions to allow access to resources in AWS Glue. See <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/attach-policy-iam-user.html">Attach a Policy to IAM Users That
     * Access AWS Glue</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * This role needs permission to your Amazon Simple Storage Service (Amazon S3) sources, targets, temporary
     * directory, scripts, and any libraries used by the task run for this transform.
     * </p>
     * </li>
     * </ul>
     * 
     * @param role
     *        The name or Amazon Resource Name (ARN) of the IAM role with the required permissions. The required
     *        permissions include both AWS Glue service role permissions to AWS Glue resources, and Amazon S3
     *        permissions required by the transform. </p>
     *        <ul>
     *        <li>
     *        <p>
     *        This role needs AWS Glue service role permissions to allow access to resources in AWS Glue. See <a
     *        href="https://docs.aws.amazon.com/glue/latest/dg/attach-policy-iam-user.html">Attach a Policy to IAM Users
     *        That Access AWS Glue</a>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        This role needs permission to your Amazon Simple Storage Service (Amazon S3) sources, targets, temporary
     *        directory, scripts, and any libraries used by the task run for this transform.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MLTransform withRole(String role) {
        setRole(role);
        return this;
    }

    /**
     * <p>
     * This value determines which version of AWS Glue this machine learning transform is compatible with. Glue 1.0 is
     * recommended for most customers. If the value is not set, the Glue compatibility defaults to Glue 0.9. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions">AWS Glue Versions</a>
     * in the developer guide.
     * </p>
     * 
     * @param glueVersion
     *        This value determines which version of AWS Glue this machine learning transform is compatible with. Glue
     *        1.0 is recommended for most customers. If the value is not set, the Glue compatibility defaults to Glue
     *        0.9. For more information, see <a
     *        href="https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions">AWS Glue
     *        Versions</a> in the developer guide.
     */

    public void setGlueVersion(String glueVersion) {
        this.glueVersion = glueVersion;
    }

    /**
     * <p>
     * This value determines which version of AWS Glue this machine learning transform is compatible with. Glue 1.0 is
     * recommended for most customers. If the value is not set, the Glue compatibility defaults to Glue 0.9. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions">AWS Glue Versions</a>
     * in the developer guide.
     * </p>
     * 
     * @return This value determines which version of AWS Glue this machine learning transform is compatible with. Glue
     *         1.0 is recommended for most customers. If the value is not set, the Glue compatibility defaults to Glue
     *         0.9. For more information, see <a
     *         href="https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions">AWS Glue
     *         Versions</a> in the developer guide.
     */

    public String getGlueVersion() {
        return this.glueVersion;
    }

    /**
     * <p>
     * This value determines which version of AWS Glue this machine learning transform is compatible with. Glue 1.0 is
     * recommended for most customers. If the value is not set, the Glue compatibility defaults to Glue 0.9. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions">AWS Glue Versions</a>
     * in the developer guide.
     * </p>
     * 
     * @param glueVersion
     *        This value determines which version of AWS Glue this machine learning transform is compatible with. Glue
     *        1.0 is recommended for most customers. If the value is not set, the Glue compatibility defaults to Glue
     *        0.9. For more information, see <a
     *        href="https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions">AWS Glue
     *        Versions</a> in the developer guide.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MLTransform withGlueVersion(String glueVersion) {
        setGlueVersion(glueVersion);
        return this;
    }

    /**
     * <p>
     * The number of AWS Glue data processing units (DPUs) that are allocated to task runs for this transform. You can
     * allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of processing power that consists of
     * 4 vCPUs of compute capacity and 16 GB of memory. For more information, see the <a
     * href="http://aws.amazon.com/glue/pricing/">AWS Glue pricing page</a>.
     * </p>
     * <p>
     * <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and
     * <code>WorkerType</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code> cannot be
     * set.
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code> can be
     * set.
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When the <code>WorkerType</code> field is set to a value other than <code>Standard</code>, the
     * <code>MaxCapacity</code> field is set automatically and becomes read-only.
     * </p>
     * 
     * @param maxCapacity
     *        The number of AWS Glue data processing units (DPUs) that are allocated to task runs for this transform.
     *        You can allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of processing power
     *        that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information, see the <a
     *        href="http://aws.amazon.com/glue/pricing/">AWS Glue pricing page</a>. </p>
     *        <p>
     *        <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and
     *        <code>WorkerType</code>.
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code>
     *        cannot be set.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code>
     *        can be set.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        When the <code>WorkerType</code> field is set to a value other than <code>Standard</code>, the
     *        <code>MaxCapacity</code> field is set automatically and becomes read-only.
     */

    public void setMaxCapacity(Double maxCapacity) {
        this.maxCapacity = maxCapacity;
    }

    /**
     * <p>
     * The number of AWS Glue data processing units (DPUs) that are allocated to task runs for this transform. You can
     * allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of processing power that consists of
     * 4 vCPUs of compute capacity and 16 GB of memory. For more information, see the <a
     * href="http://aws.amazon.com/glue/pricing/">AWS Glue pricing page</a>.
     * </p>
     * <p>
     * <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and
     * <code>WorkerType</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code> cannot be
     * set.
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code> can be
     * set.
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When the <code>WorkerType</code> field is set to a value other than <code>Standard</code>, the
     * <code>MaxCapacity</code> field is set automatically and becomes read-only.
     * </p>
     * 
     * @return The number of AWS Glue data processing units (DPUs) that are allocated to task runs for this transform.
     *         You can allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of processing power
     *         that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information, see the <a
     *         href="http://aws.amazon.com/glue/pricing/">AWS Glue pricing page</a>. </p>
     *         <p>
     *         <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and
     *         <code>WorkerType</code>.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code>
     *         cannot be set.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code>
     *         can be set.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When the <code>WorkerType</code> field is set to a value other than <code>Standard</code>, the
     *         <code>MaxCapacity</code> field is set automatically and becomes read-only.
     */

    public Double getMaxCapacity() {
        return this.maxCapacity;
    }

    /**
     * <p>
     * The number of AWS Glue data processing units (DPUs) that are allocated to task runs for this transform. You can
     * allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of processing power that consists of
     * 4 vCPUs of compute capacity and 16 GB of memory. For more information, see the <a
     * href="http://aws.amazon.com/glue/pricing/">AWS Glue pricing page</a>.
     * </p>
     * <p>
     * <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and
     * <code>WorkerType</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code> cannot be
     * set.
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code> can be
     * set.
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When the <code>WorkerType</code> field is set to a value other than <code>Standard</code>, the
     * <code>MaxCapacity</code> field is set automatically and becomes read-only.
     * </p>
     * 
     * @param maxCapacity
     *        The number of AWS Glue data processing units (DPUs) that are allocated to task runs for this transform.
     *        You can allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of processing power
     *        that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information, see the <a
     *        href="http://aws.amazon.com/glue/pricing/">AWS Glue pricing page</a>. </p>
     *        <p>
     *        <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and
     *        <code>WorkerType</code>.
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code>
     *        cannot be set.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code>
     *        can be set.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        When the <code>WorkerType</code> field is set to a value other than <code>Standard</code>, the
     *        <code>MaxCapacity</code> field is set automatically and becomes read-only.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MLTransform withMaxCapacity(Double maxCapacity) {
        setMaxCapacity(maxCapacity);
        return this;
    }

    /**
     * <p>
     * The type of predefined worker that is allocated when a task of this transform runs. Accepts a value of Standard,
     * G.1X, or G.2X.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2
     * executors per worker.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1
     * executor per worker.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and 1
     * executor per worker.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and
     * <code>WorkerType</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code> cannot be
     * set.
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code> can be
     * set.
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.
     * </p>
     * </li>
     * </ul>
     * 
     * @param workerType
     *        The type of predefined worker that is allocated when a task of this transform runs. Accepts a value of
     *        Standard, G.1X, or G.2X.</p>
     *        <ul>
     *        <li>
     *        <p>
     *        For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk,
     *        and 2 executors per worker.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1
     *        executor per worker.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and
     *        1 executor per worker.
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and
     *        <code>WorkerType</code>.
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code>
     *        cannot be set.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code>
     *        can be set.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.
     *        </p>
     *        </li>
     * @see WorkerType
     */

    public void setWorkerType(String workerType) {
        this.workerType = workerType;
    }

    /**
     * <p>
     * The type of predefined worker that is allocated when a task of this transform runs. Accepts a value of Standard,
     * G.1X, or G.2X.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2
     * executors per worker.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1
     * executor per worker.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and 1
     * executor per worker.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and
     * <code>WorkerType</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code> cannot be
     * set.
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code> can be
     * set.
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The type of predefined worker that is allocated when a task of this transform runs. Accepts a value of
     *         Standard, G.1X, or G.2X.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk,
     *         and 2 executors per worker.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and
     *         1 executor per worker.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and
     *         1 executor per worker.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and
     *         <code>WorkerType</code>.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code>
     *         cannot be set.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code>
     *         can be set.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.
     *         </p>
     *         </li>
     * @see WorkerType
     */

    public String getWorkerType() {
        return this.workerType;
    }

    /**
     * <p>
     * The type of predefined worker that is allocated when a task of this transform runs. Accepts a value of Standard,
     * G.1X, or G.2X.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2
     * executors per worker.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1
     * executor per worker.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and 1
     * executor per worker.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and
     * <code>WorkerType</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code> cannot be
     * set.
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code> can be
     * set.
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.
     * </p>
     * </li>
     * </ul>
     * 
     * @param workerType
     *        The type of predefined worker that is allocated when a task of this transform runs. Accepts a value of
     *        Standard, G.1X, or G.2X.</p>
     *        <ul>
     *        <li>
     *        <p>
     *        For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk,
     *        and 2 executors per worker.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1
     *        executor per worker.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and
     *        1 executor per worker.
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and
     *        <code>WorkerType</code>.
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code>
     *        cannot be set.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code>
     *        can be set.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see WorkerType
     */

    public MLTransform withWorkerType(String workerType) {
        setWorkerType(workerType);
        return this;
    }

    /**
     * <p>
     * The type of predefined worker that is allocated when a task of this transform runs. Accepts a value of Standard,
     * G.1X, or G.2X.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2
     * executors per worker.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1
     * executor per worker.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and 1
     * executor per worker.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and
     * <code>WorkerType</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code> cannot be
     * set.
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code> can be
     * set.
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.
     * </p>
     * </li>
     * </ul>
     * 
     * @param workerType
     *        The type of predefined worker that is allocated when a task of this transform runs. Accepts a value of
     *        Standard, G.1X, or G.2X.</p>
     *        <ul>
     *        <li>
     *        <p>
     *        For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk,
     *        and 2 executors per worker.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1
     *        executor per worker.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and
     *        1 executor per worker.
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and
     *        <code>WorkerType</code>.
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code>
     *        cannot be set.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code>
     *        can be set.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see WorkerType
     */

    public MLTransform withWorkerType(WorkerType workerType) {
        this.workerType = workerType.toString();
        return this;
    }

    /**
     * <p>
     * The number of workers of a defined <code>workerType</code> that are allocated when a task of the transform runs.
     * </p>
     * <p>
     * If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).
     * </p>
     * 
     * @param numberOfWorkers
     *        The number of workers of a defined <code>workerType</code> that are allocated when a task of the transform
     *        runs.</p>
     *        <p>
     *        If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).
     */

    public void setNumberOfWorkers(Integer numberOfWorkers) {
        this.numberOfWorkers = numberOfWorkers;
    }

    /**
     * <p>
     * The number of workers of a defined <code>workerType</code> that are allocated when a task of the transform runs.
     * </p>
     * <p>
     * If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).
     * </p>
     * 
     * @return The number of workers of a defined <code>workerType</code> that are allocated when a task of the
     *         transform runs.</p>
     *         <p>
     *         If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).
     */

    public Integer getNumberOfWorkers() {
        return this.numberOfWorkers;
    }

    /**
     * <p>
     * The number of workers of a defined <code>workerType</code> that are allocated when a task of the transform runs.
     * </p>
     * <p>
     * If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).
     * </p>
     * 
     * @param numberOfWorkers
     *        The number of workers of a defined <code>workerType</code> that are allocated when a task of the transform
     *        runs.</p>
     *        <p>
     *        If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MLTransform withNumberOfWorkers(Integer numberOfWorkers) {
        setNumberOfWorkers(numberOfWorkers);
        return this;
    }

    /**
     * <p>
     * The timeout in minutes of the machine learning transform.
     * </p>
     * 
     * @param timeout
     *        The timeout in minutes of the machine learning transform.
     */

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    /**
     * <p>
     * The timeout in minutes of the machine learning transform.
     * </p>
     * 
     * @return The timeout in minutes of the machine learning transform.
     */

    public Integer getTimeout() {
        return this.timeout;
    }

    /**
     * <p>
     * The timeout in minutes of the machine learning transform.
     * </p>
     * 
     * @param timeout
     *        The timeout in minutes of the machine learning transform.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MLTransform withTimeout(Integer timeout) {
        setTimeout(timeout);
        return this;
    }

    /**
     * <p>
     * The maximum number of times to retry after an <code>MLTaskRun</code> of the machine learning transform fails.
     * </p>
     * 
     * @param maxRetries
     *        The maximum number of times to retry after an <code>MLTaskRun</code> of the machine learning transform
     *        fails.
     */

    public void setMaxRetries(Integer maxRetries) {
        this.maxRetries = maxRetries;
    }

    /**
     * <p>
     * The maximum number of times to retry after an <code>MLTaskRun</code> of the machine learning transform fails.
     * </p>
     * 
     * @return The maximum number of times to retry after an <code>MLTaskRun</code> of the machine learning transform
     *         fails.
     */

    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    /**
     * <p>
     * The maximum number of times to retry after an <code>MLTaskRun</code> of the machine learning transform fails.
     * </p>
     * 
     * @param maxRetries
     *        The maximum number of times to retry after an <code>MLTaskRun</code> of the machine learning transform
     *        fails.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MLTransform withMaxRetries(Integer maxRetries) {
        setMaxRetries(maxRetries);
        return this;
    }

    /**
     * <p>
     * The encryption-at-rest settings of the transform that apply to accessing user data. Machine learning transforms
     * can access user data encrypted in Amazon S3 using KMS.
     * </p>
     * 
     * @param transformEncryption
     *        The encryption-at-rest settings of the transform that apply to accessing user data. Machine learning
     *        transforms can access user data encrypted in Amazon S3 using KMS.
     */

    public void setTransformEncryption(TransformEncryption transformEncryption) {
        this.transformEncryption = transformEncryption;
    }

    /**
     * <p>
     * The encryption-at-rest settings of the transform that apply to accessing user data. Machine learning transforms
     * can access user data encrypted in Amazon S3 using KMS.
     * </p>
     * 
     * @return The encryption-at-rest settings of the transform that apply to accessing user data. Machine learning
     *         transforms can access user data encrypted in Amazon S3 using KMS.
     */

    public TransformEncryption getTransformEncryption() {
        return this.transformEncryption;
    }

    /**
     * <p>
     * The encryption-at-rest settings of the transform that apply to accessing user data. Machine learning transforms
     * can access user data encrypted in Amazon S3 using KMS.
     * </p>
     * 
     * @param transformEncryption
     *        The encryption-at-rest settings of the transform that apply to accessing user data. Machine learning
     *        transforms can access user data encrypted in Amazon S3 using KMS.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MLTransform withTransformEncryption(TransformEncryption transformEncryption) {
        setTransformEncryption(transformEncryption);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getTransformId() != null)
            sb.append("TransformId: ").append(getTransformId()).append(",");
        if (getName() != null)
            sb.append("Name: ").append(getName()).append(",");
        if (getDescription() != null)
            sb.append("Description: ").append(getDescription()).append(",");
        if (getStatus() != null)
            sb.append("Status: ").append(getStatus()).append(",");
        if (getCreatedOn() != null)
            sb.append("CreatedOn: ").append(getCreatedOn()).append(",");
        if (getLastModifiedOn() != null)
            sb.append("LastModifiedOn: ").append(getLastModifiedOn()).append(",");
        if (getInputRecordTables() != null)
            sb.append("InputRecordTables: ").append(getInputRecordTables()).append(",");
        if (getParameters() != null)
            sb.append("Parameters: ").append(getParameters()).append(",");
        if (getEvaluationMetrics() != null)
            sb.append("EvaluationMetrics: ").append(getEvaluationMetrics()).append(",");
        if (getLabelCount() != null)
            sb.append("LabelCount: ").append(getLabelCount()).append(",");
        if (getSchema() != null)
            sb.append("Schema: ").append(getSchema()).append(",");
        if (getRole() != null)
            sb.append("Role: ").append(getRole()).append(",");
        if (getGlueVersion() != null)
            sb.append("GlueVersion: ").append(getGlueVersion()).append(",");
        if (getMaxCapacity() != null)
            sb.append("MaxCapacity: ").append(getMaxCapacity()).append(",");
        if (getWorkerType() != null)
            sb.append("WorkerType: ").append(getWorkerType()).append(",");
        if (getNumberOfWorkers() != null)
            sb.append("NumberOfWorkers: ").append(getNumberOfWorkers()).append(",");
        if (getTimeout() != null)
            sb.append("Timeout: ").append(getTimeout()).append(",");
        if (getMaxRetries() != null)
            sb.append("MaxRetries: ").append(getMaxRetries()).append(",");
        if (getTransformEncryption() != null)
            sb.append("TransformEncryption: ").append(getTransformEncryption());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof MLTransform == false)
            return false;
        MLTransform other = (MLTransform) obj;
        if (other.getTransformId() == null ^ this.getTransformId() == null)
            return false;
        if (other.getTransformId() != null && other.getTransformId().equals(this.getTransformId()) == false)
            return false;
        if (other.getName() == null ^ this.getName() == null)
            return false;
        if (other.getName() != null && other.getName().equals(this.getName()) == false)
            return false;
        if (other.getDescription() == null ^ this.getDescription() == null)
            return false;
        if (other.getDescription() != null && other.getDescription().equals(this.getDescription()) == false)
            return false;
        if (other.getStatus() == null ^ this.getStatus() == null)
            return false;
        if (other.getStatus() != null && other.getStatus().equals(this.getStatus()) == false)
            return false;
        if (other.getCreatedOn() == null ^ this.getCreatedOn() == null)
            return false;
        if (other.getCreatedOn() != null && other.getCreatedOn().equals(this.getCreatedOn()) == false)
            return false;
        if (other.getLastModifiedOn() == null ^ this.getLastModifiedOn() == null)
            return false;
        if (other.getLastModifiedOn() != null && other.getLastModifiedOn().equals(this.getLastModifiedOn()) == false)
            return false;
        if (other.getInputRecordTables() == null ^ this.getInputRecordTables() == null)
            return false;
        if (other.getInputRecordTables() != null && other.getInputRecordTables().equals(this.getInputRecordTables()) == false)
            return false;
        if (other.getParameters() == null ^ this.getParameters() == null)
            return false;
        if (other.getParameters() != null && other.getParameters().equals(this.getParameters()) == false)
            return false;
        if (other.getEvaluationMetrics() == null ^ this.getEvaluationMetrics() == null)
            return false;
        if (other.getEvaluationMetrics() != null && other.getEvaluationMetrics().equals(this.getEvaluationMetrics()) == false)
            return false;
        if (other.getLabelCount() == null ^ this.getLabelCount() == null)
            return false;
        if (other.getLabelCount() != null && other.getLabelCount().equals(this.getLabelCount()) == false)
            return false;
        if (other.getSchema() == null ^ this.getSchema() == null)
            return false;
        if (other.getSchema() != null && other.getSchema().equals(this.getSchema()) == false)
            return false;
        if (other.getRole() == null ^ this.getRole() == null)
            return false;
        if (other.getRole() != null && other.getRole().equals(this.getRole()) == false)
            return false;
        if (other.getGlueVersion() == null ^ this.getGlueVersion() == null)
            return false;
        if (other.getGlueVersion() != null && other.getGlueVersion().equals(this.getGlueVersion()) == false)
            return false;
        if (other.getMaxCapacity() == null ^ this.getMaxCapacity() == null)
            return false;
        if (other.getMaxCapacity() != null && other.getMaxCapacity().equals(this.getMaxCapacity()) == false)
            return false;
        if (other.getWorkerType() == null ^ this.getWorkerType() == null)
            return false;
        if (other.getWorkerType() != null && other.getWorkerType().equals(this.getWorkerType()) == false)
            return false;
        if (other.getNumberOfWorkers() == null ^ this.getNumberOfWorkers() == null)
            return false;
        if (other.getNumberOfWorkers() != null && other.getNumberOfWorkers().equals(this.getNumberOfWorkers()) == false)
            return false;
        if (other.getTimeout() == null ^ this.getTimeout() == null)
            return false;
        if (other.getTimeout() != null && other.getTimeout().equals(this.getTimeout()) == false)
            return false;
        if (other.getMaxRetries() == null ^ this.getMaxRetries() == null)
            return false;
        if (other.getMaxRetries() != null && other.getMaxRetries().equals(this.getMaxRetries()) == false)
            return false;
        if (other.getTransformEncryption() == null ^ this.getTransformEncryption() == null)
            return false;
        if (other.getTransformEncryption() != null && other.getTransformEncryption().equals(this.getTransformEncryption()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getTransformId() == null) ? 0 : getTransformId().hashCode());
        hashCode = prime * hashCode + ((getName() == null) ? 0 : getName().hashCode());
        hashCode = prime * hashCode + ((getDescription() == null) ? 0 : getDescription().hashCode());
        hashCode = prime * hashCode + ((getStatus() == null) ? 0 : getStatus().hashCode());
        hashCode = prime * hashCode + ((getCreatedOn() == null) ? 0 : getCreatedOn().hashCode());
        hashCode = prime * hashCode + ((getLastModifiedOn() == null) ? 0 : getLastModifiedOn().hashCode());
        hashCode = prime * hashCode + ((getInputRecordTables() == null) ? 0 : getInputRecordTables().hashCode());
        hashCode = prime * hashCode + ((getParameters() == null) ? 0 : getParameters().hashCode());
        hashCode = prime * hashCode + ((getEvaluationMetrics() == null) ? 0 : getEvaluationMetrics().hashCode());
        hashCode = prime * hashCode + ((getLabelCount() == null) ? 0 : getLabelCount().hashCode());
        hashCode = prime * hashCode + ((getSchema() == null) ? 0 : getSchema().hashCode());
        hashCode = prime * hashCode + ((getRole() == null) ? 0 : getRole().hashCode());
        hashCode = prime * hashCode + ((getGlueVersion() == null) ? 0 : getGlueVersion().hashCode());
        hashCode = prime * hashCode + ((getMaxCapacity() == null) ? 0 : getMaxCapacity().hashCode());
        hashCode = prime * hashCode + ((getWorkerType() == null) ? 0 : getWorkerType().hashCode());
        hashCode = prime * hashCode + ((getNumberOfWorkers() == null) ? 0 : getNumberOfWorkers().hashCode());
        hashCode = prime * hashCode + ((getTimeout() == null) ? 0 : getTimeout().hashCode());
        hashCode = prime * hashCode + ((getMaxRetries() == null) ? 0 : getMaxRetries().hashCode());
        hashCode = prime * hashCode + ((getTransformEncryption() == null) ? 0 : getTransformEncryption().hashCode());
        return hashCode;
    }

    @Override
    public MLTransform clone() {
        try {
            return (MLTransform) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.glue.model.transform.MLTransformMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
