/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.accessanalyzer.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/StartPolicyGeneration"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class StartPolicyGenerationRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * Contains the ARN of the IAM entity (user or role) for which you are generating a policy.
     * </p>
     */
    private PolicyGenerationDetails policyGenerationDetails;
    /**
     * <p>
     * A <code>CloudTrailDetails</code> object that contains details about a <code>Trail</code> that you want to analyze
     * to generate policies.
     * </p>
     */
    private CloudTrailDetails cloudTrailDetails;
    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     * ensures that an API request completes only once. With an idempotent request, if the original request completes
     * successfully, the subsequent retries with the same client token return the result from the original successful
     * request and they have no additional effect.
     * </p>
     * <p>
     * If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     * </p>
     */
    private String clientToken;

    /**
     * <p>
     * Contains the ARN of the IAM entity (user or role) for which you are generating a policy.
     * </p>
     * 
     * @param policyGenerationDetails
     *        Contains the ARN of the IAM entity (user or role) for which you are generating a policy.
     */

    public void setPolicyGenerationDetails(PolicyGenerationDetails policyGenerationDetails) {
        this.policyGenerationDetails = policyGenerationDetails;
    }

    /**
     * <p>
     * Contains the ARN of the IAM entity (user or role) for which you are generating a policy.
     * </p>
     * 
     * @return Contains the ARN of the IAM entity (user or role) for which you are generating a policy.
     */

    public PolicyGenerationDetails getPolicyGenerationDetails() {
        return this.policyGenerationDetails;
    }

    /**
     * <p>
     * Contains the ARN of the IAM entity (user or role) for which you are generating a policy.
     * </p>
     * 
     * @param policyGenerationDetails
     *        Contains the ARN of the IAM entity (user or role) for which you are generating a policy.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartPolicyGenerationRequest withPolicyGenerationDetails(PolicyGenerationDetails policyGenerationDetails) {
        setPolicyGenerationDetails(policyGenerationDetails);
        return this;
    }

    /**
     * <p>
     * A <code>CloudTrailDetails</code> object that contains details about a <code>Trail</code> that you want to analyze
     * to generate policies.
     * </p>
     * 
     * @param cloudTrailDetails
     *        A <code>CloudTrailDetails</code> object that contains details about a <code>Trail</code> that you want to
     *        analyze to generate policies.
     */

    public void setCloudTrailDetails(CloudTrailDetails cloudTrailDetails) {
        this.cloudTrailDetails = cloudTrailDetails;
    }

    /**
     * <p>
     * A <code>CloudTrailDetails</code> object that contains details about a <code>Trail</code> that you want to analyze
     * to generate policies.
     * </p>
     * 
     * @return A <code>CloudTrailDetails</code> object that contains details about a <code>Trail</code> that you want to
     *         analyze to generate policies.
     */

    public CloudTrailDetails getCloudTrailDetails() {
        return this.cloudTrailDetails;
    }

    /**
     * <p>
     * A <code>CloudTrailDetails</code> object that contains details about a <code>Trail</code> that you want to analyze
     * to generate policies.
     * </p>
     * 
     * @param cloudTrailDetails
     *        A <code>CloudTrailDetails</code> object that contains details about a <code>Trail</code> that you want to
     *        analyze to generate policies.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartPolicyGenerationRequest withCloudTrailDetails(CloudTrailDetails cloudTrailDetails) {
        setCloudTrailDetails(cloudTrailDetails);
        return this;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     * ensures that an API request completes only once. With an idempotent request, if the original request completes
     * successfully, the subsequent retries with the same client token return the result from the original successful
     * request and they have no additional effect.
     * </p>
     * <p>
     * If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     * </p>
     * 
     * @param clientToken
     *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     *        ensures that an API request completes only once. With an idempotent request, if the original request
     *        completes successfully, the subsequent retries with the same client token return the result from the
     *        original successful request and they have no additional effect.</p>
     *        <p>
     *        If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     */

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     * ensures that an API request completes only once. With an idempotent request, if the original request completes
     * successfully, the subsequent retries with the same client token return the result from the original successful
     * request and they have no additional effect.
     * </p>
     * <p>
     * If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     *         Idempotency ensures that an API request completes only once. With an idempotent request, if the original
     *         request completes successfully, the subsequent retries with the same client token return the result from
     *         the original successful request and they have no additional effect.</p>
     *         <p>
     *         If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     */

    public String getClientToken() {
        return this.clientToken;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     * ensures that an API request completes only once. With an idempotent request, if the original request completes
     * successfully, the subsequent retries with the same client token return the result from the original successful
     * request and they have no additional effect.
     * </p>
     * <p>
     * If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     * </p>
     * 
     * @param clientToken
     *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     *        ensures that an API request completes only once. With an idempotent request, if the original request
     *        completes successfully, the subsequent retries with the same client token return the result from the
     *        original successful request and they have no additional effect.</p>
     *        <p>
     *        If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartPolicyGenerationRequest withClientToken(String clientToken) {
        setClientToken(clientToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getPolicyGenerationDetails() != null)
            sb.append("PolicyGenerationDetails: ").append(getPolicyGenerationDetails()).append(",");
        if (getCloudTrailDetails() != null)
            sb.append("CloudTrailDetails: ").append(getCloudTrailDetails()).append(",");
        if (getClientToken() != null)
            sb.append("ClientToken: ").append(getClientToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof StartPolicyGenerationRequest == false)
            return false;
        StartPolicyGenerationRequest other = (StartPolicyGenerationRequest) obj;
        if (other.getPolicyGenerationDetails() == null ^ this.getPolicyGenerationDetails() == null)
            return false;
        if (other.getPolicyGenerationDetails() != null && other.getPolicyGenerationDetails().equals(this.getPolicyGenerationDetails()) == false)
            return false;
        if (other.getCloudTrailDetails() == null ^ this.getCloudTrailDetails() == null)
            return false;
        if (other.getCloudTrailDetails() != null && other.getCloudTrailDetails().equals(this.getCloudTrailDetails()) == false)
            return false;
        if (other.getClientToken() == null ^ this.getClientToken() == null)
            return false;
        if (other.getClientToken() != null && other.getClientToken().equals(this.getClientToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getPolicyGenerationDetails() == null) ? 0 : getPolicyGenerationDetails().hashCode());
        hashCode = prime * hashCode + ((getCloudTrailDetails() == null) ? 0 : getCloudTrailDetails().hashCode());
        hashCode = prime * hashCode + ((getClientToken() == null) ? 0 : getClientToken().hashCode());
        return hashCode;
    }

    @Override
    public StartPolicyGenerationRequest clone() {
        return (StartPolicyGenerationRequest) super.clone();
    }

}
