/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.appflow;

import javax.annotation.Generated;

import com.amazonaws.services.appflow.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonAppflow}. Convenient method forms pass through to the corresponding overload
 * that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonAppflow implements AmazonAppflow {

    protected AbstractAmazonAppflow() {
    }

    @Override
    public CreateConnectorProfileResult createConnectorProfile(CreateConnectorProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateFlowResult createFlow(CreateFlowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteConnectorProfileResult deleteConnectorProfile(DeleteConnectorProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteFlowResult deleteFlow(DeleteFlowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeConnectorResult describeConnector(DescribeConnectorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeConnectorEntityResult describeConnectorEntity(DescribeConnectorEntityRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeConnectorProfilesResult describeConnectorProfiles(DescribeConnectorProfilesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeConnectorsResult describeConnectors(DescribeConnectorsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeFlowResult describeFlow(DescribeFlowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeFlowExecutionRecordsResult describeFlowExecutionRecords(DescribeFlowExecutionRecordsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListConnectorEntitiesResult listConnectorEntities(ListConnectorEntitiesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListConnectorsResult listConnectors(ListConnectorsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListFlowsResult listFlows(ListFlowsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RegisterConnectorResult registerConnector(RegisterConnectorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartFlowResult startFlow(StartFlowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopFlowResult stopFlow(StopFlowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UnregisterConnectorResult unregisterConnector(UnregisterConnectorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateConnectorProfileResult updateConnectorProfile(UpdateConnectorProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateConnectorRegistrationResult updateConnectorRegistration(UpdateConnectorRegistrationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateFlowResult updateFlow(UpdateFlowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
