/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.customerprofiles.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListIdentityResolutionJobs"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListIdentityResolutionJobsResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * A list of Identity Resolution Jobs.
     * </p>
     */
    private java.util.List<IdentityResolutionJob> identityResolutionJobsList;
    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     */
    private String nextToken;

    /**
     * <p>
     * A list of Identity Resolution Jobs.
     * </p>
     * 
     * @return A list of Identity Resolution Jobs.
     */

    public java.util.List<IdentityResolutionJob> getIdentityResolutionJobsList() {
        return identityResolutionJobsList;
    }

    /**
     * <p>
     * A list of Identity Resolution Jobs.
     * </p>
     * 
     * @param identityResolutionJobsList
     *        A list of Identity Resolution Jobs.
     */

    public void setIdentityResolutionJobsList(java.util.Collection<IdentityResolutionJob> identityResolutionJobsList) {
        if (identityResolutionJobsList == null) {
            this.identityResolutionJobsList = null;
            return;
        }

        this.identityResolutionJobsList = new java.util.ArrayList<IdentityResolutionJob>(identityResolutionJobsList);
    }

    /**
     * <p>
     * A list of Identity Resolution Jobs.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setIdentityResolutionJobsList(java.util.Collection)} or
     * {@link #withIdentityResolutionJobsList(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param identityResolutionJobsList
     *        A list of Identity Resolution Jobs.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListIdentityResolutionJobsResult withIdentityResolutionJobsList(IdentityResolutionJob... identityResolutionJobsList) {
        if (this.identityResolutionJobsList == null) {
            setIdentityResolutionJobsList(new java.util.ArrayList<IdentityResolutionJob>(identityResolutionJobsList.length));
        }
        for (IdentityResolutionJob ele : identityResolutionJobsList) {
            this.identityResolutionJobsList.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of Identity Resolution Jobs.
     * </p>
     * 
     * @param identityResolutionJobsList
     *        A list of Identity Resolution Jobs.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListIdentityResolutionJobsResult withIdentityResolutionJobsList(java.util.Collection<IdentityResolutionJob> identityResolutionJobsList) {
        setIdentityResolutionJobsList(identityResolutionJobsList);
        return this;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @param nextToken
     *        If there are additional results, this is the token for the next set of results.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @return If there are additional results, this is the token for the next set of results.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @param nextToken
     *        If there are additional results, this is the token for the next set of results.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListIdentityResolutionJobsResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getIdentityResolutionJobsList() != null)
            sb.append("IdentityResolutionJobsList: ").append(getIdentityResolutionJobsList()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListIdentityResolutionJobsResult == false)
            return false;
        ListIdentityResolutionJobsResult other = (ListIdentityResolutionJobsResult) obj;
        if (other.getIdentityResolutionJobsList() == null ^ this.getIdentityResolutionJobsList() == null)
            return false;
        if (other.getIdentityResolutionJobsList() != null && other.getIdentityResolutionJobsList().equals(this.getIdentityResolutionJobsList()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getIdentityResolutionJobsList() == null) ? 0 : getIdentityResolutionJobsList().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public ListIdentityResolutionJobsResult clone() {
        try {
            return (ListIdentityResolutionJobsResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
