/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.drs.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.drs.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * ReplicationConfigurationReplicatedDisk JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ReplicationConfigurationReplicatedDiskJsonUnmarshaller implements Unmarshaller<ReplicationConfigurationReplicatedDisk, JsonUnmarshallerContext> {

    public ReplicationConfigurationReplicatedDisk unmarshall(JsonUnmarshallerContext context) throws Exception {
        ReplicationConfigurationReplicatedDisk replicationConfigurationReplicatedDisk = new ReplicationConfigurationReplicatedDisk();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("deviceName", targetDepth)) {
                    context.nextToken();
                    replicationConfigurationReplicatedDisk.setDeviceName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("iops", targetDepth)) {
                    context.nextToken();
                    replicationConfigurationReplicatedDisk.setIops(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("isBootDisk", targetDepth)) {
                    context.nextToken();
                    replicationConfigurationReplicatedDisk.setIsBootDisk(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("optimizedStagingDiskType", targetDepth)) {
                    context.nextToken();
                    replicationConfigurationReplicatedDisk.setOptimizedStagingDiskType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("stagingDiskType", targetDepth)) {
                    context.nextToken();
                    replicationConfigurationReplicatedDisk.setStagingDiskType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("throughput", targetDepth)) {
                    context.nextToken();
                    replicationConfigurationReplicatedDisk.setThroughput(context.getUnmarshaller(Long.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return replicationConfigurationReplicatedDisk;
    }

    private static ReplicationConfigurationReplicatedDiskJsonUnmarshaller instance;

    public static ReplicationConfigurationReplicatedDiskJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new ReplicationConfigurationReplicatedDiskJsonUnmarshaller();
        return instance;
    }
}
