/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.iotwireless.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/ListWirelessGatewayTaskDefinitions"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListWirelessGatewayTaskDefinitionsResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable,
        Cloneable {

    /**
     * <p>
     * The token to use to get the next set of results, or <b>null</b> if there are no additional results.
     * </p>
     */
    private String nextToken;
    /**
     * <p>
     * The list of task definitions.
     * </p>
     */
    private java.util.List<UpdateWirelessGatewayTaskEntry> taskDefinitions;

    /**
     * <p>
     * The token to use to get the next set of results, or <b>null</b> if there are no additional results.
     * </p>
     * 
     * @param nextToken
     *        The token to use to get the next set of results, or <b>null</b> if there are no additional results.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * The token to use to get the next set of results, or <b>null</b> if there are no additional results.
     * </p>
     * 
     * @return The token to use to get the next set of results, or <b>null</b> if there are no additional results.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * The token to use to get the next set of results, or <b>null</b> if there are no additional results.
     * </p>
     * 
     * @param nextToken
     *        The token to use to get the next set of results, or <b>null</b> if there are no additional results.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListWirelessGatewayTaskDefinitionsResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * <p>
     * The list of task definitions.
     * </p>
     * 
     * @return The list of task definitions.
     */

    public java.util.List<UpdateWirelessGatewayTaskEntry> getTaskDefinitions() {
        return taskDefinitions;
    }

    /**
     * <p>
     * The list of task definitions.
     * </p>
     * 
     * @param taskDefinitions
     *        The list of task definitions.
     */

    public void setTaskDefinitions(java.util.Collection<UpdateWirelessGatewayTaskEntry> taskDefinitions) {
        if (taskDefinitions == null) {
            this.taskDefinitions = null;
            return;
        }

        this.taskDefinitions = new java.util.ArrayList<UpdateWirelessGatewayTaskEntry>(taskDefinitions);
    }

    /**
     * <p>
     * The list of task definitions.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setTaskDefinitions(java.util.Collection)} or {@link #withTaskDefinitions(java.util.Collection)} if you
     * want to override the existing values.
     * </p>
     * 
     * @param taskDefinitions
     *        The list of task definitions.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListWirelessGatewayTaskDefinitionsResult withTaskDefinitions(UpdateWirelessGatewayTaskEntry... taskDefinitions) {
        if (this.taskDefinitions == null) {
            setTaskDefinitions(new java.util.ArrayList<UpdateWirelessGatewayTaskEntry>(taskDefinitions.length));
        }
        for (UpdateWirelessGatewayTaskEntry ele : taskDefinitions) {
            this.taskDefinitions.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The list of task definitions.
     * </p>
     * 
     * @param taskDefinitions
     *        The list of task definitions.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListWirelessGatewayTaskDefinitionsResult withTaskDefinitions(java.util.Collection<UpdateWirelessGatewayTaskEntry> taskDefinitions) {
        setTaskDefinitions(taskDefinitions);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken()).append(",");
        if (getTaskDefinitions() != null)
            sb.append("TaskDefinitions: ").append(getTaskDefinitions());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListWirelessGatewayTaskDefinitionsResult == false)
            return false;
        ListWirelessGatewayTaskDefinitionsResult other = (ListWirelessGatewayTaskDefinitionsResult) obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        if (other.getTaskDefinitions() == null ^ this.getTaskDefinitions() == null)
            return false;
        if (other.getTaskDefinitions() != null && other.getTaskDefinitions().equals(this.getTaskDefinitions()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        hashCode = prime * hashCode + ((getTaskDefinitions() == null) ? 0 : getTaskDefinitions().hashCode());
        return hashCode;
    }

    @Override
    public ListWirelessGatewayTaskDefinitionsResult clone() {
        try {
            return (ListWirelessGatewayTaskDefinitionsResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
