/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.lookoutmetrics.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Details about feedback submitted for an anomalous metric.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lookoutmetrics-2017-07-25/TimeSeriesFeedback" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class TimeSeriesFeedback implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The ID of the metric.
     * </p>
     */
    private String timeSeriesId;
    /**
     * <p>
     * Feedback on whether the metric is a legitimate anomaly.
     * </p>
     */
    private Boolean isAnomaly;

    /**
     * <p>
     * The ID of the metric.
     * </p>
     * 
     * @param timeSeriesId
     *        The ID of the metric.
     */

    public void setTimeSeriesId(String timeSeriesId) {
        this.timeSeriesId = timeSeriesId;
    }

    /**
     * <p>
     * The ID of the metric.
     * </p>
     * 
     * @return The ID of the metric.
     */

    public String getTimeSeriesId() {
        return this.timeSeriesId;
    }

    /**
     * <p>
     * The ID of the metric.
     * </p>
     * 
     * @param timeSeriesId
     *        The ID of the metric.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public TimeSeriesFeedback withTimeSeriesId(String timeSeriesId) {
        setTimeSeriesId(timeSeriesId);
        return this;
    }

    /**
     * <p>
     * Feedback on whether the metric is a legitimate anomaly.
     * </p>
     * 
     * @param isAnomaly
     *        Feedback on whether the metric is a legitimate anomaly.
     */

    public void setIsAnomaly(Boolean isAnomaly) {
        this.isAnomaly = isAnomaly;
    }

    /**
     * <p>
     * Feedback on whether the metric is a legitimate anomaly.
     * </p>
     * 
     * @return Feedback on whether the metric is a legitimate anomaly.
     */

    public Boolean getIsAnomaly() {
        return this.isAnomaly;
    }

    /**
     * <p>
     * Feedback on whether the metric is a legitimate anomaly.
     * </p>
     * 
     * @param isAnomaly
     *        Feedback on whether the metric is a legitimate anomaly.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public TimeSeriesFeedback withIsAnomaly(Boolean isAnomaly) {
        setIsAnomaly(isAnomaly);
        return this;
    }

    /**
     * <p>
     * Feedback on whether the metric is a legitimate anomaly.
     * </p>
     * 
     * @return Feedback on whether the metric is a legitimate anomaly.
     */

    public Boolean isAnomaly() {
        return this.isAnomaly;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getTimeSeriesId() != null)
            sb.append("TimeSeriesId: ").append(getTimeSeriesId()).append(",");
        if (getIsAnomaly() != null)
            sb.append("IsAnomaly: ").append(getIsAnomaly());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof TimeSeriesFeedback == false)
            return false;
        TimeSeriesFeedback other = (TimeSeriesFeedback) obj;
        if (other.getTimeSeriesId() == null ^ this.getTimeSeriesId() == null)
            return false;
        if (other.getTimeSeriesId() != null && other.getTimeSeriesId().equals(this.getTimeSeriesId()) == false)
            return false;
        if (other.getIsAnomaly() == null ^ this.getIsAnomaly() == null)
            return false;
        if (other.getIsAnomaly() != null && other.getIsAnomaly().equals(this.getIsAnomaly()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getTimeSeriesId() == null) ? 0 : getTimeSeriesId().hashCode());
        hashCode = prime * hashCode + ((getIsAnomaly() == null) ? 0 : getIsAnomaly().hashCode());
        return hashCode;
    }

    @Override
    public TimeSeriesFeedback clone() {
        try {
            return (TimeSeriesFeedback) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.lookoutmetrics.model.transform.TimeSeriesFeedbackMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
