/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.mediapackagevod.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.mediapackagevod.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * PackagingGroup JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class PackagingGroupJsonUnmarshaller implements Unmarshaller<PackagingGroup, JsonUnmarshallerContext> {

    public PackagingGroup unmarshall(JsonUnmarshallerContext context) throws Exception {
        PackagingGroup packagingGroup = new PackagingGroup();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("approximateAssetCount", targetDepth)) {
                    context.nextToken();
                    packagingGroup.setApproximateAssetCount(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("arn", targetDepth)) {
                    context.nextToken();
                    packagingGroup.setArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("authorization", targetDepth)) {
                    context.nextToken();
                    packagingGroup.setAuthorization(AuthorizationJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("domainName", targetDepth)) {
                    context.nextToken();
                    packagingGroup.setDomainName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("egressAccessLogs", targetDepth)) {
                    context.nextToken();
                    packagingGroup.setEgressAccessLogs(EgressAccessLogsJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("id", targetDepth)) {
                    context.nextToken();
                    packagingGroup.setId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("tags", targetDepth)) {
                    context.nextToken();
                    packagingGroup.setTags(new MapUnmarshaller<String, String>(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class))
                            .unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return packagingGroup;
    }

    private static PackagingGroupJsonUnmarshaller instance;

    public static PackagingGroupJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new PackagingGroupJsonUnmarshaller();
        return instance;
    }
}
