/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.opensearchserverless;

import javax.annotation.Generated;

import com.amazonaws.services.opensearchserverless.model.*;

/**
 * Abstract implementation of {@code AWSOpenSearchServerlessAsync}. Convenient method forms pass through to the
 * corresponding overload that takes a request object and an {@code AsyncHandler}, which throws an
 * {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSOpenSearchServerlessAsync extends AbstractAWSOpenSearchServerless implements AWSOpenSearchServerlessAsync {

    protected AbstractAWSOpenSearchServerlessAsync() {
    }

    @Override
    public java.util.concurrent.Future<BatchGetCollectionResult> batchGetCollectionAsync(BatchGetCollectionRequest request) {

        return batchGetCollectionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<BatchGetCollectionResult> batchGetCollectionAsync(BatchGetCollectionRequest request,
            com.amazonaws.handlers.AsyncHandler<BatchGetCollectionRequest, BatchGetCollectionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<BatchGetVpcEndpointResult> batchGetVpcEndpointAsync(BatchGetVpcEndpointRequest request) {

        return batchGetVpcEndpointAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<BatchGetVpcEndpointResult> batchGetVpcEndpointAsync(BatchGetVpcEndpointRequest request,
            com.amazonaws.handlers.AsyncHandler<BatchGetVpcEndpointRequest, BatchGetVpcEndpointResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateAccessPolicyResult> createAccessPolicyAsync(CreateAccessPolicyRequest request) {

        return createAccessPolicyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateAccessPolicyResult> createAccessPolicyAsync(CreateAccessPolicyRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateAccessPolicyRequest, CreateAccessPolicyResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateCollectionResult> createCollectionAsync(CreateCollectionRequest request) {

        return createCollectionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateCollectionResult> createCollectionAsync(CreateCollectionRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateCollectionRequest, CreateCollectionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateSecurityConfigResult> createSecurityConfigAsync(CreateSecurityConfigRequest request) {

        return createSecurityConfigAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateSecurityConfigResult> createSecurityConfigAsync(CreateSecurityConfigRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateSecurityConfigRequest, CreateSecurityConfigResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateSecurityPolicyResult> createSecurityPolicyAsync(CreateSecurityPolicyRequest request) {

        return createSecurityPolicyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateSecurityPolicyResult> createSecurityPolicyAsync(CreateSecurityPolicyRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateSecurityPolicyRequest, CreateSecurityPolicyResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateVpcEndpointResult> createVpcEndpointAsync(CreateVpcEndpointRequest request) {

        return createVpcEndpointAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateVpcEndpointResult> createVpcEndpointAsync(CreateVpcEndpointRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateVpcEndpointRequest, CreateVpcEndpointResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteAccessPolicyResult> deleteAccessPolicyAsync(DeleteAccessPolicyRequest request) {

        return deleteAccessPolicyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteAccessPolicyResult> deleteAccessPolicyAsync(DeleteAccessPolicyRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteAccessPolicyRequest, DeleteAccessPolicyResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteCollectionResult> deleteCollectionAsync(DeleteCollectionRequest request) {

        return deleteCollectionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteCollectionResult> deleteCollectionAsync(DeleteCollectionRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteCollectionRequest, DeleteCollectionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteSecurityConfigResult> deleteSecurityConfigAsync(DeleteSecurityConfigRequest request) {

        return deleteSecurityConfigAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteSecurityConfigResult> deleteSecurityConfigAsync(DeleteSecurityConfigRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteSecurityConfigRequest, DeleteSecurityConfigResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteSecurityPolicyResult> deleteSecurityPolicyAsync(DeleteSecurityPolicyRequest request) {

        return deleteSecurityPolicyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteSecurityPolicyResult> deleteSecurityPolicyAsync(DeleteSecurityPolicyRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteSecurityPolicyRequest, DeleteSecurityPolicyResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteVpcEndpointResult> deleteVpcEndpointAsync(DeleteVpcEndpointRequest request) {

        return deleteVpcEndpointAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteVpcEndpointResult> deleteVpcEndpointAsync(DeleteVpcEndpointRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteVpcEndpointRequest, DeleteVpcEndpointResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetAccessPolicyResult> getAccessPolicyAsync(GetAccessPolicyRequest request) {

        return getAccessPolicyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetAccessPolicyResult> getAccessPolicyAsync(GetAccessPolicyRequest request,
            com.amazonaws.handlers.AsyncHandler<GetAccessPolicyRequest, GetAccessPolicyResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetAccountSettingsResult> getAccountSettingsAsync(GetAccountSettingsRequest request) {

        return getAccountSettingsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetAccountSettingsResult> getAccountSettingsAsync(GetAccountSettingsRequest request,
            com.amazonaws.handlers.AsyncHandler<GetAccountSettingsRequest, GetAccountSettingsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetPoliciesStatsResult> getPoliciesStatsAsync(GetPoliciesStatsRequest request) {

        return getPoliciesStatsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetPoliciesStatsResult> getPoliciesStatsAsync(GetPoliciesStatsRequest request,
            com.amazonaws.handlers.AsyncHandler<GetPoliciesStatsRequest, GetPoliciesStatsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetSecurityConfigResult> getSecurityConfigAsync(GetSecurityConfigRequest request) {

        return getSecurityConfigAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetSecurityConfigResult> getSecurityConfigAsync(GetSecurityConfigRequest request,
            com.amazonaws.handlers.AsyncHandler<GetSecurityConfigRequest, GetSecurityConfigResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetSecurityPolicyResult> getSecurityPolicyAsync(GetSecurityPolicyRequest request) {

        return getSecurityPolicyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetSecurityPolicyResult> getSecurityPolicyAsync(GetSecurityPolicyRequest request,
            com.amazonaws.handlers.AsyncHandler<GetSecurityPolicyRequest, GetSecurityPolicyResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListAccessPoliciesResult> listAccessPoliciesAsync(ListAccessPoliciesRequest request) {

        return listAccessPoliciesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListAccessPoliciesResult> listAccessPoliciesAsync(ListAccessPoliciesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListAccessPoliciesRequest, ListAccessPoliciesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListCollectionsResult> listCollectionsAsync(ListCollectionsRequest request) {

        return listCollectionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListCollectionsResult> listCollectionsAsync(ListCollectionsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListCollectionsRequest, ListCollectionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListSecurityConfigsResult> listSecurityConfigsAsync(ListSecurityConfigsRequest request) {

        return listSecurityConfigsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListSecurityConfigsResult> listSecurityConfigsAsync(ListSecurityConfigsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListSecurityConfigsRequest, ListSecurityConfigsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListSecurityPoliciesResult> listSecurityPoliciesAsync(ListSecurityPoliciesRequest request) {

        return listSecurityPoliciesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListSecurityPoliciesResult> listSecurityPoliciesAsync(ListSecurityPoliciesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListSecurityPoliciesRequest, ListSecurityPoliciesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {

        return listTagsForResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListVpcEndpointsResult> listVpcEndpointsAsync(ListVpcEndpointsRequest request) {

        return listVpcEndpointsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListVpcEndpointsResult> listVpcEndpointsAsync(ListVpcEndpointsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListVpcEndpointsRequest, ListVpcEndpointsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {

        return tagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {

        return untagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateAccessPolicyResult> updateAccessPolicyAsync(UpdateAccessPolicyRequest request) {

        return updateAccessPolicyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateAccessPolicyResult> updateAccessPolicyAsync(UpdateAccessPolicyRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateAccessPolicyRequest, UpdateAccessPolicyResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateAccountSettingsResult> updateAccountSettingsAsync(UpdateAccountSettingsRequest request) {

        return updateAccountSettingsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateAccountSettingsResult> updateAccountSettingsAsync(UpdateAccountSettingsRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateAccountSettingsRequest, UpdateAccountSettingsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateCollectionResult> updateCollectionAsync(UpdateCollectionRequest request) {

        return updateCollectionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateCollectionResult> updateCollectionAsync(UpdateCollectionRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateCollectionRequest, UpdateCollectionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateSecurityConfigResult> updateSecurityConfigAsync(UpdateSecurityConfigRequest request) {

        return updateSecurityConfigAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateSecurityConfigResult> updateSecurityConfigAsync(UpdateSecurityConfigRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateSecurityConfigRequest, UpdateSecurityConfigResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateSecurityPolicyResult> updateSecurityPolicyAsync(UpdateSecurityPolicyRequest request) {

        return updateSecurityPolicyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateSecurityPolicyResult> updateSecurityPolicyAsync(UpdateSecurityPolicyRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateSecurityPolicyRequest, UpdateSecurityPolicyResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateVpcEndpointResult> updateVpcEndpointAsync(UpdateVpcEndpointRequest request) {

        return updateVpcEndpointAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateVpcEndpointResult> updateVpcEndpointAsync(UpdateVpcEndpointRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateVpcEndpointRequest, UpdateVpcEndpointResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

}
