/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.wellarchitected.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * <p>
 * Input to list lenses.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListLenses" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListLensesRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    private String nextToken;

    private Integer maxResults;
    /**
     * <p>
     * The type of lenses to be returned.
     * </p>
     */
    private String lensType;
    /**
     * <p>
     * The status of lenses to be returned.
     * </p>
     */
    private String lensStatus;

    private String lensName;

    /**
     * @param nextToken
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * @return
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * @param nextToken
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListLensesRequest withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * @param maxResults
     */

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    /**
     * @return
     */

    public Integer getMaxResults() {
        return this.maxResults;
    }

    /**
     * @param maxResults
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListLensesRequest withMaxResults(Integer maxResults) {
        setMaxResults(maxResults);
        return this;
    }

    /**
     * <p>
     * The type of lenses to be returned.
     * </p>
     * 
     * @param lensType
     *        The type of lenses to be returned.
     * @see LensType
     */

    public void setLensType(String lensType) {
        this.lensType = lensType;
    }

    /**
     * <p>
     * The type of lenses to be returned.
     * </p>
     * 
     * @return The type of lenses to be returned.
     * @see LensType
     */

    public String getLensType() {
        return this.lensType;
    }

    /**
     * <p>
     * The type of lenses to be returned.
     * </p>
     * 
     * @param lensType
     *        The type of lenses to be returned.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see LensType
     */

    public ListLensesRequest withLensType(String lensType) {
        setLensType(lensType);
        return this;
    }

    /**
     * <p>
     * The type of lenses to be returned.
     * </p>
     * 
     * @param lensType
     *        The type of lenses to be returned.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see LensType
     */

    public ListLensesRequest withLensType(LensType lensType) {
        this.lensType = lensType.toString();
        return this;
    }

    /**
     * <p>
     * The status of lenses to be returned.
     * </p>
     * 
     * @param lensStatus
     *        The status of lenses to be returned.
     * @see LensStatusType
     */

    public void setLensStatus(String lensStatus) {
        this.lensStatus = lensStatus;
    }

    /**
     * <p>
     * The status of lenses to be returned.
     * </p>
     * 
     * @return The status of lenses to be returned.
     * @see LensStatusType
     */

    public String getLensStatus() {
        return this.lensStatus;
    }

    /**
     * <p>
     * The status of lenses to be returned.
     * </p>
     * 
     * @param lensStatus
     *        The status of lenses to be returned.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see LensStatusType
     */

    public ListLensesRequest withLensStatus(String lensStatus) {
        setLensStatus(lensStatus);
        return this;
    }

    /**
     * <p>
     * The status of lenses to be returned.
     * </p>
     * 
     * @param lensStatus
     *        The status of lenses to be returned.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see LensStatusType
     */

    public ListLensesRequest withLensStatus(LensStatusType lensStatus) {
        this.lensStatus = lensStatus.toString();
        return this;
    }

    /**
     * @param lensName
     */

    public void setLensName(String lensName) {
        this.lensName = lensName;
    }

    /**
     * @return
     */

    public String getLensName() {
        return this.lensName;
    }

    /**
     * @param lensName
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListLensesRequest withLensName(String lensName) {
        setLensName(lensName);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken()).append(",");
        if (getMaxResults() != null)
            sb.append("MaxResults: ").append(getMaxResults()).append(",");
        if (getLensType() != null)
            sb.append("LensType: ").append(getLensType()).append(",");
        if (getLensStatus() != null)
            sb.append("LensStatus: ").append(getLensStatus()).append(",");
        if (getLensName() != null)
            sb.append("LensName: ").append(getLensName());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListLensesRequest == false)
            return false;
        ListLensesRequest other = (ListLensesRequest) obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        if (other.getMaxResults() == null ^ this.getMaxResults() == null)
            return false;
        if (other.getMaxResults() != null && other.getMaxResults().equals(this.getMaxResults()) == false)
            return false;
        if (other.getLensType() == null ^ this.getLensType() == null)
            return false;
        if (other.getLensType() != null && other.getLensType().equals(this.getLensType()) == false)
            return false;
        if (other.getLensStatus() == null ^ this.getLensStatus() == null)
            return false;
        if (other.getLensStatus() != null && other.getLensStatus().equals(this.getLensStatus()) == false)
            return false;
        if (other.getLensName() == null ^ this.getLensName() == null)
            return false;
        if (other.getLensName() != null && other.getLensName().equals(this.getLensName()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        hashCode = prime * hashCode + ((getMaxResults() == null) ? 0 : getMaxResults().hashCode());
        hashCode = prime * hashCode + ((getLensType() == null) ? 0 : getLensType().hashCode());
        hashCode = prime * hashCode + ((getLensStatus() == null) ? 0 : getLensStatus().hashCode());
        hashCode = prime * hashCode + ((getLensName() == null) ? 0 : getLensName().hashCode());
        return hashCode;
    }

    @Override
    public ListLensesRequest clone() {
        return (ListLensesRequest) super.clone();
    }

}
