/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codebuild.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.codebuild.model.Project;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchGetProjectsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Project> projects;
    private List<String> projectsNotFound;

    public List<Project> getProjects() {
        return this.projects;
    }

    public void setProjects(Collection<Project> projects) {
        if (projects == null) {
            this.projects = null;
            return;
        }
        this.projects = new ArrayList<Project>(projects);
    }

    public BatchGetProjectsResult withProjects(Project ... projects) {
        if (this.projects == null) {
            this.setProjects(new ArrayList<Project>(projects.length));
        }
        for (Project ele : projects) {
            this.projects.add(ele);
        }
        return this;
    }

    public BatchGetProjectsResult withProjects(Collection<Project> projects) {
        this.setProjects(projects);
        return this;
    }

    public List<String> getProjectsNotFound() {
        return this.projectsNotFound;
    }

    public void setProjectsNotFound(Collection<String> projectsNotFound) {
        if (projectsNotFound == null) {
            this.projectsNotFound = null;
            return;
        }
        this.projectsNotFound = new ArrayList<String>(projectsNotFound);
    }

    public BatchGetProjectsResult withProjectsNotFound(String ... projectsNotFound) {
        if (this.projectsNotFound == null) {
            this.setProjectsNotFound(new ArrayList<String>(projectsNotFound.length));
        }
        for (String ele : projectsNotFound) {
            this.projectsNotFound.add(ele);
        }
        return this;
    }

    public BatchGetProjectsResult withProjectsNotFound(Collection<String> projectsNotFound) {
        this.setProjectsNotFound(projectsNotFound);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getProjects() != null) {
            sb.append("Projects: ").append(this.getProjects()).append(",");
        }
        if (this.getProjectsNotFound() != null) {
            sb.append("ProjectsNotFound: ").append(this.getProjectsNotFound());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetProjectsResult)) {
            return false;
        }
        BatchGetProjectsResult other = (BatchGetProjectsResult)obj;
        if (other.getProjects() == null ^ this.getProjects() == null) {
            return false;
        }
        if (other.getProjects() != null && !other.getProjects().equals(this.getProjects())) {
            return false;
        }
        if (other.getProjectsNotFound() == null ^ this.getProjectsNotFound() == null) {
            return false;
        }
        return other.getProjectsNotFound() == null || other.getProjectsNotFound().equals(this.getProjectsNotFound());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getProjects() == null ? 0 : this.getProjects().hashCode());
        hashCode = 31 * hashCode + (this.getProjectsNotFound() == null ? 0 : this.getProjectsNotFound().hashCode());
        return hashCode;
    }

    public BatchGetProjectsResult clone() {
        try {
            return (BatchGetProjectsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

