/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codebuild.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.codebuild.model.BuildPhase;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class BuildPhaseMarshaller {
    private static final MarshallingInfo<String> PHASETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("phaseType").build();
    private static final MarshallingInfo<String> PHASESTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("phaseStatus").build();
    private static final MarshallingInfo<Date> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Long> DURATIONINSECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("durationInSeconds").build();
    private static final MarshallingInfo<List> CONTEXTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("contexts").build();
    private static final BuildPhaseMarshaller instance = new BuildPhaseMarshaller();

    public static BuildPhaseMarshaller getInstance() {
        return instance;
    }

    public void marshall(BuildPhase buildPhase, ProtocolMarshaller protocolMarshaller) {
        if (buildPhase == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)buildPhase.getPhaseType(), PHASETYPE_BINDING);
            protocolMarshaller.marshall((Object)buildPhase.getPhaseStatus(), PHASESTATUS_BINDING);
            protocolMarshaller.marshall((Object)buildPhase.getStartTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)buildPhase.getEndTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall((Object)buildPhase.getDurationInSeconds(), DURATIONINSECONDS_BINDING);
            protocolMarshaller.marshall(buildPhase.getContexts(), CONTEXTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

