/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.codedeploy.model.CreateDeploymentGroupRequest;
import com.amazonaws.services.codedeploy.model.EC2TagFilter;
import com.amazonaws.services.codedeploy.model.TagFilter;
import com.amazonaws.services.codedeploy.model.transform.EC2TagFilterJsonMarshaller;
import com.amazonaws.services.codedeploy.model.transform.TagFilterJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class CreateDeploymentGroupRequestMarshaller
implements Marshaller<Request<CreateDeploymentGroupRequest>, CreateDeploymentGroupRequest> {
    public Request<CreateDeploymentGroupRequest> marshall(CreateDeploymentGroupRequest createDeploymentGroupRequest) {
        if (createDeploymentGroupRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createDeploymentGroupRequest, "AmazonCodeDeploy");
        request.addHeader("X-Amz-Target", "CodeDeploy_20141006.CreateDeploymentGroup");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList autoScalingGroupsList;
            SdkInternalList onPremisesInstanceTagFiltersList;
            SdkInternalList ec2TagFiltersList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (createDeploymentGroupRequest.getApplicationName() != null) {
                jsonWriter.key("applicationName").value((Object)createDeploymentGroupRequest.getApplicationName());
            }
            if (createDeploymentGroupRequest.getDeploymentGroupName() != null) {
                jsonWriter.key("deploymentGroupName").value((Object)createDeploymentGroupRequest.getDeploymentGroupName());
            }
            if (createDeploymentGroupRequest.getDeploymentConfigName() != null) {
                jsonWriter.key("deploymentConfigName").value((Object)createDeploymentGroupRequest.getDeploymentConfigName());
            }
            if (!(ec2TagFiltersList = (SdkInternalList)createDeploymentGroupRequest.getEc2TagFilters()).isEmpty() || !ec2TagFiltersList.isAutoConstruct()) {
                jsonWriter.key("ec2TagFilters");
                jsonWriter.array();
                for (EC2TagFilter ec2TagFiltersListValue : ec2TagFiltersList) {
                    if (ec2TagFiltersListValue == null) continue;
                    EC2TagFilterJsonMarshaller.getInstance().marshall(ec2TagFiltersListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (!(onPremisesInstanceTagFiltersList = (SdkInternalList)createDeploymentGroupRequest.getOnPremisesInstanceTagFilters()).isEmpty() || !onPremisesInstanceTagFiltersList.isAutoConstruct()) {
                jsonWriter.key("onPremisesInstanceTagFilters");
                jsonWriter.array();
                for (TagFilter onPremisesInstanceTagFiltersListValue : onPremisesInstanceTagFiltersList) {
                    if (onPremisesInstanceTagFiltersListValue == null) continue;
                    TagFilterJsonMarshaller.getInstance().marshall(onPremisesInstanceTagFiltersListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (!(autoScalingGroupsList = (SdkInternalList)createDeploymentGroupRequest.getAutoScalingGroups()).isEmpty() || !autoScalingGroupsList.isAutoConstruct()) {
                jsonWriter.key("autoScalingGroups");
                jsonWriter.array();
                for (String autoScalingGroupsListValue : autoScalingGroupsList) {
                    if (autoScalingGroupsListValue == null) continue;
                    jsonWriter.value((Object)autoScalingGroupsListValue);
                }
                jsonWriter.endArray();
            }
            if (createDeploymentGroupRequest.getServiceRoleArn() != null) {
                jsonWriter.key("serviceRoleArn").value((Object)createDeploymentGroupRequest.getServiceRoleArn());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

