/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.codedeploy.model.InstanceInfo;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class InstanceInfoMarshaller {
    private static final MarshallingInfo<String> INSTANCENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instanceName").build();
    private static final MarshallingInfo<String> IAMSESSIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("iamSessionArn").build();
    private static final MarshallingInfo<String> IAMUSERARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("iamUserArn").build();
    private static final MarshallingInfo<String> INSTANCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instanceArn").build();
    private static final MarshallingInfo<Date> REGISTERTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("registerTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> DEREGISTERTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deregisterTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").build();
    private static final InstanceInfoMarshaller instance = new InstanceInfoMarshaller();

    public static InstanceInfoMarshaller getInstance() {
        return instance;
    }

    public void marshall(InstanceInfo instanceInfo, ProtocolMarshaller protocolMarshaller) {
        if (instanceInfo == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)instanceInfo.getInstanceName(), INSTANCENAME_BINDING);
            protocolMarshaller.marshall((Object)instanceInfo.getIamSessionArn(), IAMSESSIONARN_BINDING);
            protocolMarshaller.marshall((Object)instanceInfo.getIamUserArn(), IAMUSERARN_BINDING);
            protocolMarshaller.marshall((Object)instanceInfo.getInstanceArn(), INSTANCEARN_BINDING);
            protocolMarshaller.marshall((Object)instanceInfo.getRegisterTime(), REGISTERTIME_BINDING);
            protocolMarshaller.marshall((Object)instanceInfo.getDeregisterTime(), DEREGISTERTIME_BINDING);
            protocolMarshaller.marshall(instanceInfo.getTags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

