/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.comprehend.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.comprehend.model.DominantLanguage;
import com.amazonaws.services.comprehend.model.transform.BatchDetectDominantLanguageItemResultMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchDetectDominantLanguageItemResult
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer index;
    private List<DominantLanguage> languages;

    public void setIndex(Integer index) {
        this.index = index;
    }

    public Integer getIndex() {
        return this.index;
    }

    public BatchDetectDominantLanguageItemResult withIndex(Integer index) {
        this.setIndex(index);
        return this;
    }

    public List<DominantLanguage> getLanguages() {
        return this.languages;
    }

    public void setLanguages(Collection<DominantLanguage> languages) {
        if (languages == null) {
            this.languages = null;
            return;
        }
        this.languages = new ArrayList<DominantLanguage>(languages);
    }

    public BatchDetectDominantLanguageItemResult withLanguages(DominantLanguage ... languages) {
        if (this.languages == null) {
            this.setLanguages(new ArrayList<DominantLanguage>(languages.length));
        }
        for (DominantLanguage ele : languages) {
            this.languages.add(ele);
        }
        return this;
    }

    public BatchDetectDominantLanguageItemResult withLanguages(Collection<DominantLanguage> languages) {
        this.setLanguages(languages);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIndex() != null) {
            sb.append("Index: ").append(this.getIndex()).append(",");
        }
        if (this.getLanguages() != null) {
            sb.append("Languages: ").append(this.getLanguages());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDetectDominantLanguageItemResult)) {
            return false;
        }
        BatchDetectDominantLanguageItemResult other = (BatchDetectDominantLanguageItemResult)obj;
        if (other.getIndex() == null ^ this.getIndex() == null) {
            return false;
        }
        if (other.getIndex() != null && !other.getIndex().equals(this.getIndex())) {
            return false;
        }
        if (other.getLanguages() == null ^ this.getLanguages() == null) {
            return false;
        }
        return other.getLanguages() == null || other.getLanguages().equals(this.getLanguages());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIndex() == null ? 0 : this.getIndex().hashCode());
        hashCode = 31 * hashCode + (this.getLanguages() == null ? 0 : this.getLanguages().hashCode());
        return hashCode;
    }

    public BatchDetectDominantLanguageItemResult clone() {
        try {
            return (BatchDetectDominantLanguageItemResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BatchDetectDominantLanguageItemResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

