/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dlm.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.dlm.model.RetentionIntervalUnitValues;
import com.amazonaws.services.dlm.model.transform.ShareRuleMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ShareRule
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> targetAccounts;
    private Integer unshareInterval;
    private String unshareIntervalUnit;

    public List<String> getTargetAccounts() {
        return this.targetAccounts;
    }

    public void setTargetAccounts(Collection<String> targetAccounts) {
        if (targetAccounts == null) {
            this.targetAccounts = null;
            return;
        }
        this.targetAccounts = new ArrayList<String>(targetAccounts);
    }

    public ShareRule withTargetAccounts(String ... targetAccounts) {
        if (this.targetAccounts == null) {
            this.setTargetAccounts(new ArrayList<String>(targetAccounts.length));
        }
        for (String ele : targetAccounts) {
            this.targetAccounts.add(ele);
        }
        return this;
    }

    public ShareRule withTargetAccounts(Collection<String> targetAccounts) {
        this.setTargetAccounts(targetAccounts);
        return this;
    }

    public void setUnshareInterval(Integer unshareInterval) {
        this.unshareInterval = unshareInterval;
    }

    public Integer getUnshareInterval() {
        return this.unshareInterval;
    }

    public ShareRule withUnshareInterval(Integer unshareInterval) {
        this.setUnshareInterval(unshareInterval);
        return this;
    }

    public void setUnshareIntervalUnit(String unshareIntervalUnit) {
        this.unshareIntervalUnit = unshareIntervalUnit;
    }

    public String getUnshareIntervalUnit() {
        return this.unshareIntervalUnit;
    }

    public ShareRule withUnshareIntervalUnit(String unshareIntervalUnit) {
        this.setUnshareIntervalUnit(unshareIntervalUnit);
        return this;
    }

    public ShareRule withUnshareIntervalUnit(RetentionIntervalUnitValues unshareIntervalUnit) {
        this.unshareIntervalUnit = unshareIntervalUnit.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTargetAccounts() != null) {
            sb.append("TargetAccounts: ").append(this.getTargetAccounts()).append(",");
        }
        if (this.getUnshareInterval() != null) {
            sb.append("UnshareInterval: ").append(this.getUnshareInterval()).append(",");
        }
        if (this.getUnshareIntervalUnit() != null) {
            sb.append("UnshareIntervalUnit: ").append(this.getUnshareIntervalUnit());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShareRule)) {
            return false;
        }
        ShareRule other = (ShareRule)obj;
        if (other.getTargetAccounts() == null ^ this.getTargetAccounts() == null) {
            return false;
        }
        if (other.getTargetAccounts() != null && !other.getTargetAccounts().equals(this.getTargetAccounts())) {
            return false;
        }
        if (other.getUnshareInterval() == null ^ this.getUnshareInterval() == null) {
            return false;
        }
        if (other.getUnshareInterval() != null && !other.getUnshareInterval().equals(this.getUnshareInterval())) {
            return false;
        }
        if (other.getUnshareIntervalUnit() == null ^ this.getUnshareIntervalUnit() == null) {
            return false;
        }
        return other.getUnshareIntervalUnit() == null || other.getUnshareIntervalUnit().equals(this.getUnshareIntervalUnit());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTargetAccounts() == null ? 0 : this.getTargetAccounts().hashCode());
        hashCode = 31 * hashCode + (this.getUnshareInterval() == null ? 0 : this.getUnshareInterval().hashCode());
        hashCode = 31 * hashCode + (this.getUnshareIntervalUnit() == null ? 0 : this.getUnshareIntervalUnit().hashCode());
        return hashCode;
    }

    public ShareRule clone() {
        try {
            return (ShareRule)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ShareRuleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

