/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatchevents.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.cloudwatchevents.model.Rule;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class RuleJsonMarshaller {
    private static RuleJsonMarshaller instance;

    public void marshall(Rule rule, StructuredJsonGenerator jsonGenerator) {
        if (rule == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (rule.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(rule.getName());
            }
            if (rule.getArn() != null) {
                jsonGenerator.writeFieldName("Arn").writeValue(rule.getArn());
            }
            if (rule.getEventPattern() != null) {
                jsonGenerator.writeFieldName("EventPattern").writeValue(rule.getEventPattern());
            }
            if (rule.getState() != null) {
                jsonGenerator.writeFieldName("State").writeValue(rule.getState());
            }
            if (rule.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(rule.getDescription());
            }
            if (rule.getScheduleExpression() != null) {
                jsonGenerator.writeFieldName("ScheduleExpression").writeValue(rule.getScheduleExpression());
            }
            if (rule.getRoleArn() != null) {
                jsonGenerator.writeFieldName("RoleArn").writeValue(rule.getRoleArn());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RuleJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RuleJsonMarshaller();
        }
        return instance;
    }
}

