/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.guardduty.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.guardduty.model.RemoteIpDetails;
import com.amazonaws.services.guardduty.model.transform.KubernetesApiCallActionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class KubernetesApiCallAction
implements Serializable,
Cloneable,
StructuredPojo {
    private String requestUri;
    private String verb;
    private List<String> sourceIps;
    private String userAgent;
    private RemoteIpDetails remoteIpDetails;
    private Integer statusCode;
    private String parameters;

    public void setRequestUri(String requestUri) {
        this.requestUri = requestUri;
    }

    public String getRequestUri() {
        return this.requestUri;
    }

    public KubernetesApiCallAction withRequestUri(String requestUri) {
        this.setRequestUri(requestUri);
        return this;
    }

    public void setVerb(String verb) {
        this.verb = verb;
    }

    public String getVerb() {
        return this.verb;
    }

    public KubernetesApiCallAction withVerb(String verb) {
        this.setVerb(verb);
        return this;
    }

    public List<String> getSourceIps() {
        return this.sourceIps;
    }

    public void setSourceIps(Collection<String> sourceIps) {
        if (sourceIps == null) {
            this.sourceIps = null;
            return;
        }
        this.sourceIps = new ArrayList<String>(sourceIps);
    }

    public KubernetesApiCallAction withSourceIps(String ... sourceIps) {
        if (this.sourceIps == null) {
            this.setSourceIps(new ArrayList<String>(sourceIps.length));
        }
        for (String ele : sourceIps) {
            this.sourceIps.add(ele);
        }
        return this;
    }

    public KubernetesApiCallAction withSourceIps(Collection<String> sourceIps) {
        this.setSourceIps(sourceIps);
        return this;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public KubernetesApiCallAction withUserAgent(String userAgent) {
        this.setUserAgent(userAgent);
        return this;
    }

    public void setRemoteIpDetails(RemoteIpDetails remoteIpDetails) {
        this.remoteIpDetails = remoteIpDetails;
    }

    public RemoteIpDetails getRemoteIpDetails() {
        return this.remoteIpDetails;
    }

    public KubernetesApiCallAction withRemoteIpDetails(RemoteIpDetails remoteIpDetails) {
        this.setRemoteIpDetails(remoteIpDetails);
        return this;
    }

    public void setStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public KubernetesApiCallAction withStatusCode(Integer statusCode) {
        this.setStatusCode(statusCode);
        return this;
    }

    public void setParameters(String parameters) {
        this.parameters = parameters;
    }

    public String getParameters() {
        return this.parameters;
    }

    public KubernetesApiCallAction withParameters(String parameters) {
        this.setParameters(parameters);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRequestUri() != null) {
            sb.append("RequestUri: ").append(this.getRequestUri()).append(",");
        }
        if (this.getVerb() != null) {
            sb.append("Verb: ").append(this.getVerb()).append(",");
        }
        if (this.getSourceIps() != null) {
            sb.append("SourceIps: ").append(this.getSourceIps()).append(",");
        }
        if (this.getUserAgent() != null) {
            sb.append("UserAgent: ").append(this.getUserAgent()).append(",");
        }
        if (this.getRemoteIpDetails() != null) {
            sb.append("RemoteIpDetails: ").append(this.getRemoteIpDetails()).append(",");
        }
        if (this.getStatusCode() != null) {
            sb.append("StatusCode: ").append(this.getStatusCode()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KubernetesApiCallAction)) {
            return false;
        }
        KubernetesApiCallAction other = (KubernetesApiCallAction)obj;
        if (other.getRequestUri() == null ^ this.getRequestUri() == null) {
            return false;
        }
        if (other.getRequestUri() != null && !other.getRequestUri().equals(this.getRequestUri())) {
            return false;
        }
        if (other.getVerb() == null ^ this.getVerb() == null) {
            return false;
        }
        if (other.getVerb() != null && !other.getVerb().equals(this.getVerb())) {
            return false;
        }
        if (other.getSourceIps() == null ^ this.getSourceIps() == null) {
            return false;
        }
        if (other.getSourceIps() != null && !other.getSourceIps().equals(this.getSourceIps())) {
            return false;
        }
        if (other.getUserAgent() == null ^ this.getUserAgent() == null) {
            return false;
        }
        if (other.getUserAgent() != null && !other.getUserAgent().equals(this.getUserAgent())) {
            return false;
        }
        if (other.getRemoteIpDetails() == null ^ this.getRemoteIpDetails() == null) {
            return false;
        }
        if (other.getRemoteIpDetails() != null && !other.getRemoteIpDetails().equals(this.getRemoteIpDetails())) {
            return false;
        }
        if (other.getStatusCode() == null ^ this.getStatusCode() == null) {
            return false;
        }
        if (other.getStatusCode() != null && !other.getStatusCode().equals(this.getStatusCode())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        return other.getParameters() == null || other.getParameters().equals(this.getParameters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRequestUri() == null ? 0 : this.getRequestUri().hashCode());
        hashCode = 31 * hashCode + (this.getVerb() == null ? 0 : this.getVerb().hashCode());
        hashCode = 31 * hashCode + (this.getSourceIps() == null ? 0 : this.getSourceIps().hashCode());
        hashCode = 31 * hashCode + (this.getUserAgent() == null ? 0 : this.getUserAgent().hashCode());
        hashCode = 31 * hashCode + (this.getRemoteIpDetails() == null ? 0 : this.getRemoteIpDetails().hashCode());
        hashCode = 31 * hashCode + (this.getStatusCode() == null ? 0 : this.getStatusCode().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        return hashCode;
    }

    public KubernetesApiCallAction clone() {
        try {
            return (KubernetesApiCallAction)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KubernetesApiCallActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

