/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.guardduty.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.guardduty.model.DataSourceConfigurations;
import com.amazonaws.services.guardduty.model.DetectorFeatureConfiguration;
import com.amazonaws.services.guardduty.model.FindingPublishingFrequency;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateDetectorRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String detectorId;
    private Boolean enable;
    private String findingPublishingFrequency;
    @Deprecated
    private DataSourceConfigurations dataSources;
    private List<DetectorFeatureConfiguration> features;

    public void setDetectorId(String detectorId) {
        this.detectorId = detectorId;
    }

    public String getDetectorId() {
        return this.detectorId;
    }

    public UpdateDetectorRequest withDetectorId(String detectorId) {
        this.setDetectorId(detectorId);
        return this;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public Boolean getEnable() {
        return this.enable;
    }

    public UpdateDetectorRequest withEnable(Boolean enable) {
        this.setEnable(enable);
        return this;
    }

    public Boolean isEnable() {
        return this.enable;
    }

    public void setFindingPublishingFrequency(String findingPublishingFrequency) {
        this.findingPublishingFrequency = findingPublishingFrequency;
    }

    public String getFindingPublishingFrequency() {
        return this.findingPublishingFrequency;
    }

    public UpdateDetectorRequest withFindingPublishingFrequency(String findingPublishingFrequency) {
        this.setFindingPublishingFrequency(findingPublishingFrequency);
        return this;
    }

    public UpdateDetectorRequest withFindingPublishingFrequency(FindingPublishingFrequency findingPublishingFrequency) {
        this.findingPublishingFrequency = findingPublishingFrequency.toString();
        return this;
    }

    @Deprecated
    public void setDataSources(DataSourceConfigurations dataSources) {
        this.dataSources = dataSources;
    }

    @Deprecated
    public DataSourceConfigurations getDataSources() {
        return this.dataSources;
    }

    @Deprecated
    public UpdateDetectorRequest withDataSources(DataSourceConfigurations dataSources) {
        this.setDataSources(dataSources);
        return this;
    }

    public List<DetectorFeatureConfiguration> getFeatures() {
        return this.features;
    }

    public void setFeatures(Collection<DetectorFeatureConfiguration> features) {
        if (features == null) {
            this.features = null;
            return;
        }
        this.features = new ArrayList<DetectorFeatureConfiguration>(features);
    }

    public UpdateDetectorRequest withFeatures(DetectorFeatureConfiguration ... features) {
        if (this.features == null) {
            this.setFeatures(new ArrayList<DetectorFeatureConfiguration>(features.length));
        }
        for (DetectorFeatureConfiguration ele : features) {
            this.features.add(ele);
        }
        return this;
    }

    public UpdateDetectorRequest withFeatures(Collection<DetectorFeatureConfiguration> features) {
        this.setFeatures(features);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDetectorId() != null) {
            sb.append("DetectorId: ").append(this.getDetectorId()).append(",");
        }
        if (this.getEnable() != null) {
            sb.append("Enable: ").append(this.getEnable()).append(",");
        }
        if (this.getFindingPublishingFrequency() != null) {
            sb.append("FindingPublishingFrequency: ").append(this.getFindingPublishingFrequency()).append(",");
        }
        if (this.getDataSources() != null) {
            sb.append("DataSources: ").append(this.getDataSources()).append(",");
        }
        if (this.getFeatures() != null) {
            sb.append("Features: ").append(this.getFeatures());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDetectorRequest)) {
            return false;
        }
        UpdateDetectorRequest other = (UpdateDetectorRequest)obj;
        if (other.getDetectorId() == null ^ this.getDetectorId() == null) {
            return false;
        }
        if (other.getDetectorId() != null && !other.getDetectorId().equals(this.getDetectorId())) {
            return false;
        }
        if (other.getEnable() == null ^ this.getEnable() == null) {
            return false;
        }
        if (other.getEnable() != null && !other.getEnable().equals(this.getEnable())) {
            return false;
        }
        if (other.getFindingPublishingFrequency() == null ^ this.getFindingPublishingFrequency() == null) {
            return false;
        }
        if (other.getFindingPublishingFrequency() != null && !other.getFindingPublishingFrequency().equals(this.getFindingPublishingFrequency())) {
            return false;
        }
        if (other.getDataSources() == null ^ this.getDataSources() == null) {
            return false;
        }
        if (other.getDataSources() != null && !other.getDataSources().equals(this.getDataSources())) {
            return false;
        }
        if (other.getFeatures() == null ^ this.getFeatures() == null) {
            return false;
        }
        return other.getFeatures() == null || other.getFeatures().equals(this.getFeatures());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDetectorId() == null ? 0 : this.getDetectorId().hashCode());
        hashCode = 31 * hashCode + (this.getEnable() == null ? 0 : this.getEnable().hashCode());
        hashCode = 31 * hashCode + (this.getFindingPublishingFrequency() == null ? 0 : this.getFindingPublishingFrequency().hashCode());
        hashCode = 31 * hashCode + (this.getDataSources() == null ? 0 : this.getDataSources().hashCode());
        hashCode = 31 * hashCode + (this.getFeatures() == null ? 0 : this.getFeatures().hashCode());
        return hashCode;
    }

    public UpdateDetectorRequest clone() {
        return (UpdateDetectorRequest)super.clone();
    }
}

