/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.guardduty.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.guardduty.model.transform.CreateS3BucketResourceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateS3BucketResource
implements Serializable,
Cloneable,
StructuredPojo {
    private String bucketName;
    private List<String> objectPrefixes;

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public CreateS3BucketResource withBucketName(String bucketName) {
        this.setBucketName(bucketName);
        return this;
    }

    public List<String> getObjectPrefixes() {
        return this.objectPrefixes;
    }

    public void setObjectPrefixes(Collection<String> objectPrefixes) {
        if (objectPrefixes == null) {
            this.objectPrefixes = null;
            return;
        }
        this.objectPrefixes = new ArrayList<String>(objectPrefixes);
    }

    public CreateS3BucketResource withObjectPrefixes(String ... objectPrefixes) {
        if (this.objectPrefixes == null) {
            this.setObjectPrefixes(new ArrayList<String>(objectPrefixes.length));
        }
        for (String ele : objectPrefixes) {
            this.objectPrefixes.add(ele);
        }
        return this;
    }

    public CreateS3BucketResource withObjectPrefixes(Collection<String> objectPrefixes) {
        this.setObjectPrefixes(objectPrefixes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBucketName() != null) {
            sb.append("BucketName: ").append(this.getBucketName()).append(",");
        }
        if (this.getObjectPrefixes() != null) {
            sb.append("ObjectPrefixes: ").append(this.getObjectPrefixes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateS3BucketResource)) {
            return false;
        }
        CreateS3BucketResource other = (CreateS3BucketResource)obj;
        if (other.getBucketName() == null ^ this.getBucketName() == null) {
            return false;
        }
        if (other.getBucketName() != null && !other.getBucketName().equals(this.getBucketName())) {
            return false;
        }
        if (other.getObjectPrefixes() == null ^ this.getObjectPrefixes() == null) {
            return false;
        }
        return other.getObjectPrefixes() == null || other.getObjectPrefixes().equals(this.getObjectPrefixes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBucketName() == null ? 0 : this.getBucketName().hashCode());
        hashCode = 31 * hashCode + (this.getObjectPrefixes() == null ? 0 : this.getObjectPrefixes().hashCode());
        return hashCode;
    }

    public CreateS3BucketResource clone() {
        try {
            return (CreateS3BucketResource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CreateS3BucketResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

