/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisfirehose.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.kinesisfirehose.model.UpdateDestinationRequest;
import com.amazonaws.services.kinesisfirehose.model.transform.RedshiftDestinationUpdateJsonMarshaller;
import com.amazonaws.services.kinesisfirehose.model.transform.S3DestinationUpdateJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class UpdateDestinationRequestMarshaller
implements Marshaller<Request<UpdateDestinationRequest>, UpdateDestinationRequest> {
    public Request<UpdateDestinationRequest> marshall(UpdateDestinationRequest updateDestinationRequest) {
        if (updateDestinationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateDestinationRequest, "AmazonKinesisFirehose");
        request.addHeader("X-Amz-Target", "Firehose_20150804.UpdateDestination");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (updateDestinationRequest.getDeliveryStreamName() != null) {
                jsonWriter.key("DeliveryStreamName").value((Object)updateDestinationRequest.getDeliveryStreamName());
            }
            if (updateDestinationRequest.getCurrentDeliveryStreamVersionId() != null) {
                jsonWriter.key("CurrentDeliveryStreamVersionId").value((Object)updateDestinationRequest.getCurrentDeliveryStreamVersionId());
            }
            if (updateDestinationRequest.getDestinationId() != null) {
                jsonWriter.key("DestinationId").value((Object)updateDestinationRequest.getDestinationId());
            }
            if (updateDestinationRequest.getS3DestinationUpdate() != null) {
                jsonWriter.key("S3DestinationUpdate");
                S3DestinationUpdateJsonMarshaller.getInstance().marshall(updateDestinationRequest.getS3DestinationUpdate(), jsonWriter);
            }
            if (updateDestinationRequest.getRedshiftDestinationUpdate() != null) {
                jsonWriter.key("RedshiftDestinationUpdate");
                RedshiftDestinationUpdateJsonMarshaller.getInstance().marshall(updateDestinationRequest.getRedshiftDestinationUpdate(), jsonWriter);
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

