/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.lightsail.model.InstanceEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateCloudFormationStackRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<InstanceEntry> instances;

    public List<InstanceEntry> getInstances() {
        return this.instances;
    }

    public void setInstances(Collection<InstanceEntry> instances) {
        if (instances == null) {
            this.instances = null;
            return;
        }
        this.instances = new ArrayList<InstanceEntry>(instances);
    }

    public CreateCloudFormationStackRequest withInstances(InstanceEntry ... instances) {
        if (this.instances == null) {
            this.setInstances(new ArrayList<InstanceEntry>(instances.length));
        }
        for (InstanceEntry ele : instances) {
            this.instances.add(ele);
        }
        return this;
    }

    public CreateCloudFormationStackRequest withInstances(Collection<InstanceEntry> instances) {
        this.setInstances(instances);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstances() != null) {
            sb.append("Instances: ").append(this.getInstances());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCloudFormationStackRequest)) {
            return false;
        }
        CreateCloudFormationStackRequest other = (CreateCloudFormationStackRequest)obj;
        if (other.getInstances() == null ^ this.getInstances() == null) {
            return false;
        }
        return other.getInstances() == null || other.getInstances().equals(this.getInstances());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstances() == null ? 0 : this.getInstances().hashCode());
        return hashCode;
    }

    public CreateCloudFormationStackRequest clone() {
        return (CreateCloudFormationStackRequest)super.clone();
    }
}

